/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.EvaluationFormQuestion;
import software.amazon.awssdk.services.connect.model.EvaluationFormSection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationFormItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationFormItem> {
    private static final SdkField<EvaluationFormSection> SECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Section").getter(EvaluationFormItem.getter(EvaluationFormItem::section)).setter(EvaluationFormItem.setter(Builder::section)).constructor(EvaluationFormSection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Section").build()}).build();
    private static final SdkField<EvaluationFormQuestion> QUESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Question").getter(EvaluationFormItem.getter(EvaluationFormItem::question)).setter(EvaluationFormItem.setter(Builder::question)).constructor(EvaluationFormQuestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Question").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTION_FIELD, QUESTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationFormItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EvaluationFormSection section;
    private final EvaluationFormQuestion question;
    private final Type type;

    private EvaluationFormItem(BuilderImpl builder) {
        this.section = builder.section;
        this.question = builder.question;
        this.type = builder.type;
    }

    public final EvaluationFormSection section() {
        return this.section;
    }

    public final EvaluationFormQuestion question() {
        return this.question;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.section());
        hashCode = 31 * hashCode + Objects.hashCode(this.question());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormItem)) {
            return false;
        }
        EvaluationFormItem other = (EvaluationFormItem)obj;
        return Objects.equals(this.section(), other.section()) && Objects.equals(this.question(), other.question());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationFormItem").add("Section", (Object)this.section()).add("Question", (Object)this.question()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Section": {
                return Optional.ofNullable(clazz.cast(this.section()));
            }
            case "Question": {
                return Optional.ofNullable(clazz.cast(this.question()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationFormItem fromSection(EvaluationFormSection section) {
        return (EvaluationFormItem)EvaluationFormItem.builder().section(section).build();
    }

    public static EvaluationFormItem fromSection(Consumer<EvaluationFormSection.Builder> section) {
        EvaluationFormSection.Builder builder = EvaluationFormSection.builder();
        section.accept(builder);
        return EvaluationFormItem.fromSection((EvaluationFormSection)builder.build());
    }

    public static EvaluationFormItem fromQuestion(EvaluationFormQuestion question) {
        return (EvaluationFormItem)EvaluationFormItem.builder().question(question).build();
    }

    public static EvaluationFormItem fromQuestion(Consumer<EvaluationFormQuestion.Builder> question) {
        EvaluationFormQuestion.Builder builder = EvaluationFormQuestion.builder();
        question.accept(builder);
        return EvaluationFormItem.fromQuestion((EvaluationFormQuestion)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Section", SECTION_FIELD);
        map.put("Question", QUESTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormItem, T> g) {
        return obj -> g.apply((EvaluationFormItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SECTION,
        QUESTION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EvaluationFormSection section;
        private EvaluationFormQuestion question;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormItem model) {
            this.section(model.section);
            this.question(model.question);
        }

        public final EvaluationFormSection.Builder getSection() {
            return this.section != null ? this.section.toBuilder() : null;
        }

        public final void setSection(EvaluationFormSection.BuilderImpl section) {
            EvaluationFormSection oldValue = this.section;
            this.section = section != null ? section.build() : null;
            this.handleUnionValueChange(Type.SECTION, oldValue, this.section);
        }

        @Override
        public final Builder section(EvaluationFormSection section) {
            EvaluationFormSection oldValue = this.section;
            this.section = section;
            this.handleUnionValueChange(Type.SECTION, oldValue, this.section);
            return this;
        }

        public final EvaluationFormQuestion.Builder getQuestion() {
            return this.question != null ? this.question.toBuilder() : null;
        }

        public final void setQuestion(EvaluationFormQuestion.BuilderImpl question) {
            EvaluationFormQuestion oldValue = this.question;
            this.question = question != null ? question.build() : null;
            this.handleUnionValueChange(Type.QUESTION, oldValue, this.question);
        }

        @Override
        public final Builder question(EvaluationFormQuestion question) {
            EvaluationFormQuestion oldValue = this.question;
            this.question = question;
            this.handleUnionValueChange(Type.QUESTION, oldValue, this.question);
            return this;
        }

        public EvaluationFormItem build() {
            return new EvaluationFormItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationFormItem> {
        public Builder section(EvaluationFormSection var1);

        default public Builder section(Consumer<EvaluationFormSection.Builder> section) {
            return this.section((EvaluationFormSection)((EvaluationFormSection.Builder)EvaluationFormSection.builder().applyMutation(section)).build());
        }

        public Builder question(EvaluationFormQuestion var1);

        default public Builder question(Consumer<EvaluationFormQuestion.Builder> question) {
            return this.question((EvaluationFormQuestion)((EvaluationFormQuestion.Builder)EvaluationFormQuestion.builder().applyMutation(question)).build());
        }
    }
}

