/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateAnalyticsDataSetResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, AssociateAnalyticsDataSetResponse> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(AssociateAnalyticsDataSetResponse.getter(AssociateAnalyticsDataSetResponse::dataSetId)).setter(AssociateAnalyticsDataSetResponse.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()}).build();
    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAccountId").getter(AssociateAnalyticsDataSetResponse.getter(AssociateAnalyticsDataSetResponse::targetAccountId)).setter(AssociateAnalyticsDataSetResponse.setter(Builder::targetAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAccountId").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceShareId").getter(AssociateAnalyticsDataSetResponse.getter(AssociateAnalyticsDataSetResponse::resourceShareId)).setter(AssociateAnalyticsDataSetResponse.setter(Builder::resourceShareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareId").build()}).build();
    private static final SdkField<String> RESOURCE_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceShareArn").getter(AssociateAnalyticsDataSetResponse.getter(AssociateAnalyticsDataSetResponse::resourceShareArn)).setter(AssociateAnalyticsDataSetResponse.setter(Builder::resourceShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceShareArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD, TARGET_ACCOUNT_ID_FIELD, RESOURCE_SHARE_ID_FIELD, RESOURCE_SHARE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateAnalyticsDataSetResponse.memberNameToFieldInitializer();
    private final String dataSetId;
    private final String targetAccountId;
    private final String resourceShareId;
    private final String resourceShareArn;

    private AssociateAnalyticsDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetId = builder.dataSetId;
        this.targetAccountId = builder.targetAccountId;
        this.resourceShareId = builder.resourceShareId;
        this.resourceShareArn = builder.resourceShareArn;
    }

    public final String dataSetId() {
        return this.dataSetId;
    }

    public final String targetAccountId() {
        return this.targetAccountId;
    }

    public final String resourceShareId() {
        return this.resourceShareId;
    }

    public final String resourceShareArn() {
        return this.resourceShareArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceShareArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAnalyticsDataSetResponse)) {
            return false;
        }
        AssociateAnalyticsDataSetResponse other = (AssociateAnalyticsDataSetResponse)((Object)obj);
        return Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.targetAccountId(), other.targetAccountId()) && Objects.equals(this.resourceShareId(), other.resourceShareId()) && Objects.equals(this.resourceShareArn(), other.resourceShareArn());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateAnalyticsDataSetResponse").add("DataSetId", (Object)this.dataSetId()).add("TargetAccountId", (Object)this.targetAccountId()).add("ResourceShareId", (Object)this.resourceShareId()).add("ResourceShareArn", (Object)this.resourceShareArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "TargetAccountId": {
                return Optional.ofNullable(clazz.cast(this.targetAccountId()));
            }
            case "ResourceShareId": {
                return Optional.ofNullable(clazz.cast(this.resourceShareId()));
            }
            case "ResourceShareArn": {
                return Optional.ofNullable(clazz.cast(this.resourceShareArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("TargetAccountId", TARGET_ACCOUNT_ID_FIELD);
        map.put("ResourceShareId", RESOURCE_SHARE_ID_FIELD);
        map.put("ResourceShareArn", RESOURCE_SHARE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateAnalyticsDataSetResponse, T> g) {
        return obj -> g.apply((AssociateAnalyticsDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String dataSetId;
        private String targetAccountId;
        private String resourceShareId;
        private String resourceShareArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAnalyticsDataSetResponse model) {
            super(model);
            this.dataSetId(model.dataSetId);
            this.targetAccountId(model.targetAccountId);
            this.resourceShareId(model.resourceShareId);
            this.resourceShareArn(model.resourceShareArn);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getTargetAccountId() {
            return this.targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getResourceShareId() {
            return this.resourceShareId;
        }

        public final void setResourceShareId(String resourceShareId) {
            this.resourceShareId = resourceShareId;
        }

        @Override
        public final Builder resourceShareId(String resourceShareId) {
            this.resourceShareId = resourceShareId;
            return this;
        }

        public final String getResourceShareArn() {
            return this.resourceShareArn;
        }

        public final void setResourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
        }

        @Override
        public final Builder resourceShareArn(String resourceShareArn) {
            this.resourceShareArn = resourceShareArn;
            return this;
        }

        @Override
        public AssociateAnalyticsDataSetResponse build() {
            return new AssociateAnalyticsDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateAnalyticsDataSetResponse> {
        public Builder dataSetId(String var1);

        public Builder targetAccountId(String var1);

        public Builder resourceShareId(String var1);

        public Builder resourceShareArn(String var1);
    }
}

