/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AnsweringMachineDetectionStatus {
    ANSWERED("ANSWERED"),
    UNDETECTED("UNDETECTED"),
    ERROR("ERROR"),
    HUMAN_ANSWERED("HUMAN_ANSWERED"),
    SIT_TONE_DETECTED("SIT_TONE_DETECTED"),
    SIT_TONE_BUSY("SIT_TONE_BUSY"),
    SIT_TONE_INVALID_NUMBER("SIT_TONE_INVALID_NUMBER"),
    FAX_MACHINE_DETECTED("FAX_MACHINE_DETECTED"),
    VOICEMAIL_BEEP("VOICEMAIL_BEEP"),
    VOICEMAIL_NO_BEEP("VOICEMAIL_NO_BEEP"),
    AMD_UNRESOLVED("AMD_UNRESOLVED"),
    AMD_UNANSWERED("AMD_UNANSWERED"),
    AMD_ERROR("AMD_ERROR"),
    AMD_NOT_APPLICABLE("AMD_NOT_APPLICABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AnsweringMachineDetectionStatus> VALUE_MAP;
    private final String value;

    private AnsweringMachineDetectionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AnsweringMachineDetectionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AnsweringMachineDetectionStatus> knownValues() {
        EnumSet<AnsweringMachineDetectionStatus> knownValues = EnumSet.allOf(AnsweringMachineDetectionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AnsweringMachineDetectionStatus.class, AnsweringMachineDetectionStatus::toString);
    }
}

