/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModule;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesResponse;

public class SearchContactFlowModulesIterable
implements SdkIterable<SearchContactFlowModulesResponse> {
    private final ConnectClient client;
    private final SearchContactFlowModulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchContactFlowModulesIterable(ConnectClient client, SearchContactFlowModulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchContactFlowModulesResponseFetcher();
    }

    public Iterator<SearchContactFlowModulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowModule> contactFlowModules() {
        Function<SearchContactFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModules() != null) {
                return response.contactFlowModules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchContactFlowModulesResponseFetcher
    implements SyncPageFetcher<SearchContactFlowModulesResponse> {
        private SearchContactFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchContactFlowModulesResponse nextPage(SearchContactFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return SearchContactFlowModulesIterable.this.client.searchContactFlowModules(SearchContactFlowModulesIterable.this.firstRequest);
            }
            return SearchContactFlowModulesIterable.this.client.searchContactFlowModules((SearchContactFlowModulesRequest)((Object)SearchContactFlowModulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

