/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.ListHoursOfOperationOverridesResponse;

public class ListHoursOfOperationOverridesIterable
implements SdkIterable<ListHoursOfOperationOverridesResponse> {
    private final ConnectClient client;
    private final ListHoursOfOperationOverridesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHoursOfOperationOverridesIterable(ConnectClient client, ListHoursOfOperationOverridesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListHoursOfOperationOverridesResponseFetcher();
    }

    public Iterator<ListHoursOfOperationOverridesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HoursOfOperationOverride> hoursOfOperationOverrideList() {
        Function<ListHoursOfOperationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationOverrideList() != null) {
                return response.hoursOfOperationOverrideList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHoursOfOperationOverridesResponseFetcher
    implements SyncPageFetcher<ListHoursOfOperationOverridesResponse> {
        private ListHoursOfOperationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(ListHoursOfOperationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHoursOfOperationOverridesResponse nextPage(ListHoursOfOperationOverridesResponse previousPage) {
            if (previousPage == null) {
                return ListHoursOfOperationOverridesIterable.this.client.listHoursOfOperationOverrides(ListHoursOfOperationOverridesIterable.this.firstRequest);
            }
            return ListHoursOfOperationOverridesIterable.this.client.listHoursOfOperationOverrides((ListHoursOfOperationOverridesRequest)((Object)ListHoursOfOperationOverridesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

