/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowVersionSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowVersionsResponse;

public class ListContactFlowVersionsIterable
implements SdkIterable<ListContactFlowVersionsResponse> {
    private final ConnectClient client;
    private final ListContactFlowVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListContactFlowVersionsIterable(ConnectClient client, ListContactFlowVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListContactFlowVersionsResponseFetcher();
    }

    public Iterator<ListContactFlowVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ContactFlowVersionSummary> contactFlowVersionSummaryList() {
        Function<ListContactFlowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowVersionSummaryList() != null) {
                return response.contactFlowVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListContactFlowVersionsResponseFetcher
    implements SyncPageFetcher<ListContactFlowVersionsResponse> {
        private ListContactFlowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListContactFlowVersionsResponse nextPage(ListContactFlowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowVersionsIterable.this.client.listContactFlowVersions(ListContactFlowVersionsIterable.this.firstRequest);
            }
            return ListContactFlowVersionsIterable.this.client.listContactFlowVersions((ListContactFlowVersionsRequest)((Object)ListContactFlowVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

