/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LexVersion {
    V1("V1"),
    V2("V2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LexVersion> VALUE_MAP;
    private final String value;

    private LexVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LexVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LexVersion> knownValues() {
        EnumSet<LexVersion> knownValues = EnumSet.allOf(LexVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LexVersion.class, LexVersion::toString);
    }
}

