/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.Dimensions;
import software.amazon.awssdk.services.connect.model.HistoricalMetricData;
import software.amazon.awssdk.services.connect.model.HistoricalMetricDataCollectionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HistoricalMetricResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HistoricalMetricResult> {
    private static final SdkField<Dimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Dimensions").getter(HistoricalMetricResult.getter(HistoricalMetricResult::dimensions)).setter(HistoricalMetricResult.setter(Builder::dimensions)).constructor(Dimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<List<HistoricalMetricData>> COLLECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Collections").getter(HistoricalMetricResult.getter(HistoricalMetricResult::collections)).setter(HistoricalMetricResult.setter(Builder::collections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistoricalMetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, COLLECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HistoricalMetricResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Dimensions dimensions;
    private final List<HistoricalMetricData> collections;

    private HistoricalMetricResult(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.collections = builder.collections;
    }

    public final Dimensions dimensions() {
        return this.dimensions;
    }

    public final boolean hasCollections() {
        return this.collections != null && !(this.collections instanceof SdkAutoConstructList);
    }

    public final List<HistoricalMetricData> collections() {
        return this.collections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollections() ? this.collections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetricResult)) {
            return false;
        }
        HistoricalMetricResult other = (HistoricalMetricResult)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && this.hasCollections() == other.hasCollections() && Objects.equals(this.collections(), other.collections());
    }

    public final String toString() {
        return ToString.builder((String)"HistoricalMetricResult").add("Dimensions", (Object)this.dimensions()).add("Collections", this.hasCollections() ? this.collections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Collections": {
                return Optional.ofNullable(clazz.cast(this.collections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("Collections", COLLECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistoricalMetricResult, T> g) {
        return obj -> g.apply((HistoricalMetricResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Dimensions dimensions;
        private List<HistoricalMetricData> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalMetricResult model) {
            this.dimensions(model.dimensions);
            this.collections(model.collections);
        }

        public final Dimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(Dimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final List<HistoricalMetricData.Builder> getCollections() {
            List<HistoricalMetricData.Builder> result = HistoricalMetricDataCollectionsCopier.copyToBuilder(this.collections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollections(Collection<HistoricalMetricData.BuilderImpl> collections) {
            this.collections = HistoricalMetricDataCollectionsCopier.copyFromBuilder(collections);
        }

        @Override
        public final Builder collections(Collection<HistoricalMetricData> collections) {
            this.collections = HistoricalMetricDataCollectionsCopier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(HistoricalMetricData ... collections) {
            this.collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<HistoricalMetricData.Builder> ... collections) {
            this.collections(Stream.of(collections).map(c -> (HistoricalMetricData)((HistoricalMetricData.Builder)HistoricalMetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HistoricalMetricResult build() {
            return new HistoricalMetricResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HistoricalMetricResult> {
        public Builder dimensions(Dimensions var1);

        default public Builder dimensions(Consumer<Dimensions.Builder> dimensions) {
            return this.dimensions((Dimensions)((Dimensions.Builder)Dimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder collections(Collection<HistoricalMetricData> var1);

        public Builder collections(HistoricalMetricData ... var1);

        public Builder collections(Consumer<HistoricalMetricData.Builder> ... var1);
    }
}

