/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RehydrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePersistentContactAssociationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreatePersistentContactAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreatePersistentContactAssociationRequest.getter(CreatePersistentContactAssociationRequest::instanceId)).setter(CreatePersistentContactAssociationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialContactId").getter(CreatePersistentContactAssociationRequest.getter(CreatePersistentContactAssociationRequest::initialContactId)).setter(CreatePersistentContactAssociationRequest.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InitialContactId").build()}).build();
    private static final SdkField<String> REHYDRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RehydrationType").getter(CreatePersistentContactAssociationRequest.getter(CreatePersistentContactAssociationRequest::rehydrationTypeAsString)).setter(CreatePersistentContactAssociationRequest.setter(Builder::rehydrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RehydrationType").build()}).build();
    private static final SdkField<String> SOURCE_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceContactId").getter(CreatePersistentContactAssociationRequest.getter(CreatePersistentContactAssociationRequest::sourceContactId)).setter(CreatePersistentContactAssociationRequest.setter(Builder::sourceContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceContactId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreatePersistentContactAssociationRequest.getter(CreatePersistentContactAssociationRequest::clientToken)).setter(CreatePersistentContactAssociationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, INITIAL_CONTACT_ID_FIELD, REHYDRATION_TYPE_FIELD, SOURCE_CONTACT_ID_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePersistentContactAssociationRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String initialContactId;
    private final String rehydrationType;
    private final String sourceContactId;
    private final String clientToken;

    private CreatePersistentContactAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.initialContactId = builder.initialContactId;
        this.rehydrationType = builder.rehydrationType;
        this.sourceContactId = builder.sourceContactId;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final RehydrationType rehydrationType() {
        return RehydrationType.fromValue(this.rehydrationType);
    }

    public final String rehydrationTypeAsString() {
        return this.rehydrationType;
    }

    public final String sourceContactId() {
        return this.sourceContactId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rehydrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePersistentContactAssociationRequest)) {
            return false;
        }
        CreatePersistentContactAssociationRequest other = (CreatePersistentContactAssociationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.rehydrationTypeAsString(), other.rehydrationTypeAsString()) && Objects.equals(this.sourceContactId(), other.sourceContactId()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePersistentContactAssociationRequest").add("InstanceId", (Object)this.instanceId()).add("InitialContactId", (Object)this.initialContactId()).add("RehydrationType", (Object)this.rehydrationTypeAsString()).add("SourceContactId", (Object)this.sourceContactId()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InitialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "RehydrationType": {
                return Optional.ofNullable(clazz.cast(this.rehydrationTypeAsString()));
            }
            case "SourceContactId": {
                return Optional.ofNullable(clazz.cast(this.sourceContactId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InitialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("RehydrationType", REHYDRATION_TYPE_FIELD);
        map.put("SourceContactId", SOURCE_CONTACT_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePersistentContactAssociationRequest, T> g) {
        return obj -> g.apply((CreatePersistentContactAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String initialContactId;
        private String rehydrationType;
        private String sourceContactId;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePersistentContactAssociationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.initialContactId(model.initialContactId);
            this.rehydrationType(model.rehydrationType);
            this.sourceContactId(model.sourceContactId);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getRehydrationType() {
            return this.rehydrationType;
        }

        public final void setRehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
        }

        @Override
        public final Builder rehydrationType(String rehydrationType) {
            this.rehydrationType = rehydrationType;
            return this;
        }

        @Override
        public final Builder rehydrationType(RehydrationType rehydrationType) {
            this.rehydrationType(rehydrationType == null ? null : rehydrationType.toString());
            return this;
        }

        public final String getSourceContactId() {
            return this.sourceContactId;
        }

        public final void setSourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
        }

        @Override
        public final Builder sourceContactId(String sourceContactId) {
            this.sourceContactId = sourceContactId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePersistentContactAssociationRequest build() {
            return new CreatePersistentContactAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePersistentContactAssociationRequest> {
        public Builder instanceId(String var1);

        public Builder initialContactId(String var1);

        public Builder rehydrationType(String var1);

        public Builder rehydrationType(RehydrationType var1);

        public Builder sourceContactId(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

