/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactEvaluation> {
    private static final SdkField<String> FORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FormId").getter(ContactEvaluation.getter(ContactEvaluation::formId)).setter(ContactEvaluation.setter(Builder::formId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormId").build()}).build();
    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationArn").getter(ContactEvaluation.getter(ContactEvaluation::evaluationArn)).setter(ContactEvaluation.setter(Builder::evaluationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ContactEvaluation.getter(ContactEvaluation::statusAsString)).setter(ContactEvaluation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTimestamp").getter(ContactEvaluation.getter(ContactEvaluation::startTimestamp)).setter(ContactEvaluation.setter(Builder::startTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()}).build();
    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTimestamp").getter(ContactEvaluation.getter(ContactEvaluation::endTimestamp)).setter(ContactEvaluation.setter(Builder::endTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()}).build();
    private static final SdkField<Instant> DELETE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTimestamp").getter(ContactEvaluation.getter(ContactEvaluation::deleteTimestamp)).setter(ContactEvaluation.setter(Builder::deleteTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTimestamp").build()}).build();
    private static final SdkField<String> EXPORT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportLocation").getter(ContactEvaluation.getter(ContactEvaluation::exportLocation)).setter(ContactEvaluation.setter(Builder::exportLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORM_ID_FIELD, EVALUATION_ARN_FIELD, STATUS_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, DELETE_TIMESTAMP_FIELD, EXPORT_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactEvaluation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String formId;
    private final String evaluationArn;
    private final String status;
    private final Instant startTimestamp;
    private final Instant endTimestamp;
    private final Instant deleteTimestamp;
    private final String exportLocation;

    private ContactEvaluation(BuilderImpl builder) {
        this.formId = builder.formId;
        this.evaluationArn = builder.evaluationArn;
        this.status = builder.status;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.deleteTimestamp = builder.deleteTimestamp;
        this.exportLocation = builder.exportLocation;
    }

    public final String formId() {
        return this.formId;
    }

    public final String evaluationArn() {
        return this.evaluationArn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTimestamp() {
        return this.startTimestamp;
    }

    public final Instant endTimestamp() {
        return this.endTimestamp;
    }

    public final Instant deleteTimestamp() {
        return this.deleteTimestamp;
    }

    public final String exportLocation() {
        return this.exportLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactEvaluation)) {
            return false;
        }
        ContactEvaluation other = (ContactEvaluation)obj;
        return Objects.equals(this.formId(), other.formId()) && Objects.equals(this.evaluationArn(), other.evaluationArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTimestamp(), other.startTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp()) && Objects.equals(this.deleteTimestamp(), other.deleteTimestamp()) && Objects.equals(this.exportLocation(), other.exportLocation());
    }

    public final String toString() {
        return ToString.builder((String)"ContactEvaluation").add("FormId", (Object)this.formId()).add("EvaluationArn", (Object)this.evaluationArn()).add("Status", (Object)this.statusAsString()).add("StartTimestamp", (Object)this.startTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).add("DeleteTimestamp", (Object)this.deleteTimestamp()).add("ExportLocation", (Object)this.exportLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FormId": {
                return Optional.ofNullable(clazz.cast(this.formId()));
            }
            case "EvaluationArn": {
                return Optional.ofNullable(clazz.cast(this.evaluationArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.startTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
            case "DeleteTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deleteTimestamp()));
            }
            case "ExportLocation": {
                return Optional.ofNullable(clazz.cast(this.exportLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FormId", FORM_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTimestamp", START_TIMESTAMP_FIELD);
        map.put("EndTimestamp", END_TIMESTAMP_FIELD);
        map.put("DeleteTimestamp", DELETE_TIMESTAMP_FIELD);
        map.put("ExportLocation", EXPORT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactEvaluation, T> g) {
        return obj -> g.apply((ContactEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String formId;
        private String evaluationArn;
        private String status;
        private Instant startTimestamp;
        private Instant endTimestamp;
        private Instant deleteTimestamp;
        private String exportLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactEvaluation model) {
            this.formId(model.formId);
            this.evaluationArn(model.evaluationArn);
            this.status(model.status);
            this.startTimestamp(model.startTimestamp);
            this.endTimestamp(model.endTimestamp);
            this.deleteTimestamp(model.deleteTimestamp);
            this.exportLocation(model.exportLocation);
        }

        public final String getFormId() {
            return this.formId;
        }

        public final void setFormId(String formId) {
            this.formId = formId;
        }

        @Override
        public final Builder formId(String formId) {
            this.formId = formId;
            return this;
        }

        public final String getEvaluationArn() {
            return this.evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return this.startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final Instant getDeleteTimestamp() {
            return this.deleteTimestamp;
        }

        public final void setDeleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
        }

        @Override
        public final Builder deleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this;
        }

        public final String getExportLocation() {
            return this.exportLocation;
        }

        public final void setExportLocation(String exportLocation) {
            this.exportLocation = exportLocation;
        }

        @Override
        public final Builder exportLocation(String exportLocation) {
            this.exportLocation = exportLocation;
            return this;
        }

        public ContactEvaluation build() {
            return new ContactEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactEvaluation> {
        public Builder formId(String var1);

        public Builder evaluationArn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder startTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);

        public Builder deleteTimestamp(Instant var1);

        public Builder exportLocation(String var1);
    }
}

