/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ConnectionData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartWebRtcContactResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, StartWebRtcContactResponse> {
    private static final SdkField<ConnectionData> CONNECTION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionData").getter(StartWebRtcContactResponse.getter(StartWebRtcContactResponse::connectionData)).setter(StartWebRtcContactResponse.setter(Builder::connectionData)).constructor(ConnectionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionData").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartWebRtcContactResponse.getter(StartWebRtcContactResponse::contactId)).setter(StartWebRtcContactResponse.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(StartWebRtcContactResponse.getter(StartWebRtcContactResponse::participantId)).setter(StartWebRtcContactResponse.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantToken").getter(StartWebRtcContactResponse.getter(StartWebRtcContactResponse::participantToken)).setter(StartWebRtcContactResponse.setter(Builder::participantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_DATA_FIELD, CONTACT_ID_FIELD, PARTICIPANT_ID_FIELD, PARTICIPANT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartWebRtcContactResponse.memberNameToFieldInitializer();
    private final ConnectionData connectionData;
    private final String contactId;
    private final String participantId;
    private final String participantToken;

    private StartWebRtcContactResponse(BuilderImpl builder) {
        super(builder);
        this.connectionData = builder.connectionData;
        this.contactId = builder.contactId;
        this.participantId = builder.participantId;
        this.participantToken = builder.participantToken;
    }

    public final ConnectionData connectionData() {
        return this.connectionData;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String participantToken() {
        return this.participantToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartWebRtcContactResponse)) {
            return false;
        }
        StartWebRtcContactResponse other = (StartWebRtcContactResponse)((Object)obj);
        return Objects.equals(this.connectionData(), other.connectionData()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.participantToken(), other.participantToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartWebRtcContactResponse").add("ConnectionData", (Object)this.connectionData()).add("ContactId", (Object)this.contactId()).add("ParticipantId", (Object)this.participantId()).add("ParticipantToken", (Object)this.participantToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionData": {
                return Optional.ofNullable(clazz.cast(this.connectionData()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "ParticipantToken": {
                return Optional.ofNullable(clazz.cast(this.participantToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionData", CONNECTION_DATA_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ParticipantId", PARTICIPANT_ID_FIELD);
        map.put("ParticipantToken", PARTICIPANT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartWebRtcContactResponse, T> g) {
        return obj -> g.apply((StartWebRtcContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private ConnectionData connectionData;
        private String contactId;
        private String participantId;
        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartWebRtcContactResponse model) {
            super(model);
            this.connectionData(model.connectionData);
            this.contactId(model.contactId);
            this.participantId(model.participantId);
            this.participantToken(model.participantToken);
        }

        public final ConnectionData.Builder getConnectionData() {
            return this.connectionData != null ? this.connectionData.toBuilder() : null;
        }

        public final void setConnectionData(ConnectionData.BuilderImpl connectionData) {
            this.connectionData = connectionData != null ? connectionData.build() : null;
        }

        @Override
        public final Builder connectionData(ConnectionData connectionData) {
            this.connectionData = connectionData;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantToken() {
            return this.participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        @Override
        public StartWebRtcContactResponse build() {
            return new StartWebRtcContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartWebRtcContactResponse> {
        public Builder connectionData(ConnectionData var1);

        default public Builder connectionData(Consumer<ConnectionData.Builder> connectionData) {
            return this.connectionData((ConnectionData)((ConnectionData.Builder)ConnectionData.builder().applyMutation(connectionData)).build());
        }

        public Builder contactId(String var1);

        public Builder participantId(String var1);

        public Builder participantToken(String var1);
    }
}

