/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.RuleAction;
import software.amazon.awssdk.services.connect.model.RuleActionsCopier;
import software.amazon.awssdk.services.connect.model.RulePublishStatus;
import software.amazon.awssdk.services.connect.model.RuleTriggerEventSource;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Rule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Rule.getter(Rule::name)).setter(Rule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(Rule.getter(Rule::ruleId)).setter(Rule.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(Rule.getter(Rule::ruleArn)).setter(Rule.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<RuleTriggerEventSource> TRIGGER_EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TriggerEventSource").getter(Rule.getter(Rule::triggerEventSource)).setter(Rule.setter(Builder::triggerEventSource)).constructor(RuleTriggerEventSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerEventSource").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Function").getter(Rule.getter(Rule::function)).setter(Rule.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Function").build()}).build();
    private static final SdkField<List<RuleAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(Rule.getter(Rule::actions)).setter(Rule.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLISH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishStatus").getter(Rule.getter(Rule::publishStatusAsString)).setter(Rule.setter(Builder::publishStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishStatus").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Rule.getter(Rule::createdTime)).setter(Rule.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Rule.getter(Rule::lastUpdatedTime)).setter(Rule.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedBy").getter(Rule.getter(Rule::lastUpdatedBy)).setter(Rule.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(Rule.getter(Rule::tags)).setter(Rule.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RULE_ID_FIELD, RULE_ARN_FIELD, TRIGGER_EVENT_SOURCE_FIELD, FUNCTION_FIELD, ACTIONS_FIELD, PUBLISH_STATUS_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, LAST_UPDATED_BY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Rule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String ruleId;
    private final String ruleArn;
    private final RuleTriggerEventSource triggerEventSource;
    private final String function;
    private final List<RuleAction> actions;
    private final String publishStatus;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String lastUpdatedBy;
    private final Map<String, String> tags;

    private Rule(BuilderImpl builder) {
        this.name = builder.name;
        this.ruleId = builder.ruleId;
        this.ruleArn = builder.ruleArn;
        this.triggerEventSource = builder.triggerEventSource;
        this.function = builder.function;
        this.actions = builder.actions;
        this.publishStatus = builder.publishStatus;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final RuleTriggerEventSource triggerEventSource() {
        return this.triggerEventSource;
    }

    public final String function() {
        return this.function;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<RuleAction> actions() {
        return this.actions;
    }

    public final RulePublishStatus publishStatus() {
        return RulePublishStatus.fromValue(this.publishStatus);
    }

    public final String publishStatusAsString() {
        return this.publishStatus;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerEventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publishStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.triggerEventSource(), other.triggerEventSource()) && Objects.equals(this.function(), other.function()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.publishStatusAsString(), other.publishStatusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Rule").add("Name", (Object)this.name()).add("RuleId", (Object)this.ruleId()).add("RuleArn", (Object)this.ruleArn()).add("TriggerEventSource", (Object)this.triggerEventSource()).add("Function", (Object)this.function()).add("Actions", this.hasActions() ? this.actions() : null).add("PublishStatus", (Object)this.publishStatusAsString()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "TriggerEventSource": {
                return Optional.ofNullable(clazz.cast(this.triggerEventSource()));
            }
            case "Function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "PublishStatus": {
                return Optional.ofNullable(clazz.cast(this.publishStatusAsString()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("TriggerEventSource", TRIGGER_EVENT_SOURCE_FIELD);
        map.put("Function", FUNCTION_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("PublishStatus", PUBLISH_STATUS_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String ruleId;
        private String ruleArn;
        private RuleTriggerEventSource triggerEventSource;
        private String function;
        private List<RuleAction> actions = DefaultSdkAutoConstructList.getInstance();
        private String publishStatus;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String lastUpdatedBy;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.name(model.name);
            this.ruleId(model.ruleId);
            this.ruleArn(model.ruleArn);
            this.triggerEventSource(model.triggerEventSource);
            this.function(model.function);
            this.actions(model.actions);
            this.publishStatus(model.publishStatus);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.lastUpdatedBy(model.lastUpdatedBy);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final RuleTriggerEventSource.Builder getTriggerEventSource() {
            return this.triggerEventSource != null ? this.triggerEventSource.toBuilder() : null;
        }

        public final void setTriggerEventSource(RuleTriggerEventSource.BuilderImpl triggerEventSource) {
            this.triggerEventSource = triggerEventSource != null ? triggerEventSource.build() : null;
        }

        @Override
        public final Builder triggerEventSource(RuleTriggerEventSource triggerEventSource) {
            this.triggerEventSource = triggerEventSource;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        public final List<RuleAction.Builder> getActions() {
            List<RuleAction.Builder> result = RuleActionsCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<RuleAction.BuilderImpl> actions) {
            this.actions = RuleActionsCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<RuleAction> actions) {
            this.actions = RuleActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(RuleAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<RuleAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (RuleAction)((RuleAction.Builder)RuleAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublishStatus() {
            return this.publishStatus;
        }

        public final void setPublishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
        }

        @Override
        public final Builder publishStatus(String publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        @Override
        public final Builder publishStatus(RulePublishStatus publishStatus) {
            this.publishStatus(publishStatus == null ? null : publishStatus.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public Rule build() {
            return new Rule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Rule> {
        public Builder name(String var1);

        public Builder ruleId(String var1);

        public Builder ruleArn(String var1);

        public Builder triggerEventSource(RuleTriggerEventSource var1);

        default public Builder triggerEventSource(Consumer<RuleTriggerEventSource.Builder> triggerEventSource) {
            return this.triggerEventSource((RuleTriggerEventSource)((RuleTriggerEventSource.Builder)RuleTriggerEventSource.builder().applyMutation(triggerEventSource)).build());
        }

        public Builder function(String var1);

        public Builder actions(Collection<RuleAction> var1);

        public Builder actions(RuleAction ... var1);

        public Builder actions(Consumer<RuleAction.Builder> ... var1);

        public Builder publishStatus(String var1);

        public Builder publishStatus(RulePublishStatus var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder lastUpdatedBy(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

