/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ParticipantTimerType;
import software.amazon.awssdk.services.connect.model.ParticipantTimerValue;
import software.amazon.awssdk.services.connect.model.TimerEligibleParticipantRoles;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipantTimerConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipantTimerConfiguration> {
    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantRole").getter(ParticipantTimerConfiguration.getter(ParticipantTimerConfiguration::participantRoleAsString)).setter(ParticipantTimerConfiguration.setter(Builder::participantRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()}).build();
    private static final SdkField<String> TIMER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimerType").getter(ParticipantTimerConfiguration.getter(ParticipantTimerConfiguration::timerTypeAsString)).setter(ParticipantTimerConfiguration.setter(Builder::timerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimerType").build()}).build();
    private static final SdkField<ParticipantTimerValue> TIMER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimerValue").getter(ParticipantTimerConfiguration.getter(ParticipantTimerConfiguration::timerValue)).setter(ParticipantTimerConfiguration.setter(Builder::timerValue)).constructor(ParticipantTimerValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimerValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTICIPANT_ROLE_FIELD, TIMER_TYPE_FIELD, TIMER_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipantTimerConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String participantRole;
    private final String timerType;
    private final ParticipantTimerValue timerValue;

    private ParticipantTimerConfiguration(BuilderImpl builder) {
        this.participantRole = builder.participantRole;
        this.timerType = builder.timerType;
        this.timerValue = builder.timerValue;
    }

    public final TimerEligibleParticipantRoles participantRole() {
        return TimerEligibleParticipantRoles.fromValue(this.participantRole);
    }

    public final String participantRoleAsString() {
        return this.participantRole;
    }

    public final ParticipantTimerType timerType() {
        return ParticipantTimerType.fromValue(this.timerType);
    }

    public final String timerTypeAsString() {
        return this.timerType;
    }

    public final ParticipantTimerValue timerValue() {
        return this.timerValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timerValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipantTimerConfiguration)) {
            return false;
        }
        ParticipantTimerConfiguration other = (ParticipantTimerConfiguration)obj;
        return Objects.equals(this.participantRoleAsString(), other.participantRoleAsString()) && Objects.equals(this.timerTypeAsString(), other.timerTypeAsString()) && Objects.equals(this.timerValue(), other.timerValue());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipantTimerConfiguration").add("ParticipantRole", (Object)this.participantRoleAsString()).add("TimerType", (Object)this.timerTypeAsString()).add("TimerValue", (Object)this.timerValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParticipantRole": {
                return Optional.ofNullable(clazz.cast(this.participantRoleAsString()));
            }
            case "TimerType": {
                return Optional.ofNullable(clazz.cast(this.timerTypeAsString()));
            }
            case "TimerValue": {
                return Optional.ofNullable(clazz.cast(this.timerValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("TimerType", TIMER_TYPE_FIELD);
        map.put("TimerValue", TIMER_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipantTimerConfiguration, T> g) {
        return obj -> g.apply((ParticipantTimerConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String participantRole;
        private String timerType;
        private ParticipantTimerValue timerValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipantTimerConfiguration model) {
            this.participantRole(model.participantRole);
            this.timerType(model.timerType);
            this.timerValue(model.timerValue);
        }

        public final String getParticipantRole() {
            return this.participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(TimerEligibleParticipantRoles participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final String getTimerType() {
            return this.timerType;
        }

        public final void setTimerType(String timerType) {
            this.timerType = timerType;
        }

        @Override
        public final Builder timerType(String timerType) {
            this.timerType = timerType;
            return this;
        }

        @Override
        public final Builder timerType(ParticipantTimerType timerType) {
            this.timerType(timerType == null ? null : timerType.toString());
            return this;
        }

        public final ParticipantTimerValue.Builder getTimerValue() {
            return this.timerValue != null ? this.timerValue.toBuilder() : null;
        }

        public final void setTimerValue(ParticipantTimerValue.BuilderImpl timerValue) {
            this.timerValue = timerValue != null ? timerValue.build() : null;
        }

        @Override
        public final Builder timerValue(ParticipantTimerValue timerValue) {
            this.timerValue = timerValue;
            return this;
        }

        public ParticipantTimerConfiguration build() {
            return new ParticipantTimerConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipantTimerConfiguration> {
        public Builder participantRole(String var1);

        public Builder participantRole(TimerEligibleParticipantRoles var1);

        public Builder timerType(String var1);

        public Builder timerType(ParticipantTimerType var1);

        public Builder timerValue(ParticipantTimerValue var1);

        default public Builder timerValue(Consumer<ParticipantTimerValue.Builder> timerValue) {
            return this.timerValue((ParticipantTimerValue)((ParticipantTimerValue.Builder)ParticipantTimerValue.builder().applyMutation(timerValue)).build());
        }
    }
}

