/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.FilterV2;
import software.amazon.awssdk.services.connect.model.FiltersV2ListCopier;
import software.amazon.awssdk.services.connect.model.GroupingsV2Copier;
import software.amazon.awssdk.services.connect.model.IntervalDetails;
import software.amazon.awssdk.services.connect.model.MetricV2;
import software.amazon.awssdk.services.connect.model.MetricsV2Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataV2Request
extends ConnectRequest
implements ToCopyableBuilder<Builder, GetMetricDataV2Request> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::resourceArn)).setter(GetMetricDataV2Request.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::startTime)).setter(GetMetricDataV2Request.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::endTime)).setter(GetMetricDataV2Request.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<IntervalDetails> INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Interval").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::interval)).setter(GetMetricDataV2Request.setter(Builder::interval)).constructor(IntervalDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()}).build();
    private static final SdkField<List<FilterV2>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::filters)).setter(GetMetricDataV2Request.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groupings").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::groupings)).setter(GetMetricDataV2Request.setter(Builder::groupings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricV2>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::metrics)).setter(GetMetricDataV2Request.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::nextToken)).setter(GetMetricDataV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetMetricDataV2Request.getter(GetMetricDataV2Request::maxResults)).setter(GetMetricDataV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, START_TIME_FIELD, END_TIME_FIELD, INTERVAL_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMetricDataV2Request.memberNameToFieldInitializer();
    private final String resourceArn;
    private final Instant startTime;
    private final Instant endTime;
    private final IntervalDetails interval;
    private final List<FilterV2> filters;
    private final List<String> groupings;
    private final List<MetricV2> metrics;
    private final String nextToken;
    private final Integer maxResults;

    private GetMetricDataV2Request(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.interval = builder.interval;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final IntervalDetails interval() {
        return this.interval;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<FilterV2> filters() {
        return this.filters;
    }

    public final boolean hasGroupings() {
        return this.groupings != null && !(this.groupings instanceof SdkAutoConstructList);
    }

    public final List<String> groupings() {
        return this.groupings;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<MetricV2> metrics() {
        return this.metrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.interval());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupings() ? this.groupings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataV2Request)) {
            return false;
        }
        GetMetricDataV2Request other = (GetMetricDataV2Request)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.interval(), other.interval()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && this.hasGroupings() == other.hasGroupings() && Objects.equals(this.groupings(), other.groupings()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricDataV2Request").add("ResourceArn", (Object)this.resourceArn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Interval", (Object)this.interval()).add("Filters", this.hasFilters() ? this.filters() : null).add("Groupings", this.hasGroupings() ? this.groupings() : null).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Interval": {
                return Optional.ofNullable(clazz.cast(this.interval()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Groupings": {
                return Optional.ofNullable(clazz.cast(this.groupings()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Interval", INTERVAL_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("Groupings", GROUPINGS_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataV2Request, T> g) {
        return obj -> g.apply((GetMetricDataV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private Instant startTime;
        private Instant endTime;
        private IntervalDetails interval;
        private List<FilterV2> filters = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();
        private List<MetricV2> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataV2Request model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.interval(model.interval);
            this.filters(model.filters);
            this.groupings(model.groupings);
            this.metrics(model.metrics);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final IntervalDetails.Builder getInterval() {
            return this.interval != null ? this.interval.toBuilder() : null;
        }

        public final void setInterval(IntervalDetails.BuilderImpl interval) {
            this.interval = interval != null ? interval.build() : null;
        }

        @Override
        public final Builder interval(IntervalDetails interval) {
            this.interval = interval;
            return this;
        }

        public final List<FilterV2.Builder> getFilters() {
            List<FilterV2.Builder> result = FiltersV2ListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<FilterV2.BuilderImpl> filters) {
            this.filters = FiltersV2ListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<FilterV2> filters) {
            this.filters = FiltersV2ListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(FilterV2 ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<FilterV2.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (FilterV2)((FilterV2.Builder)FilterV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGroupings() {
            if (this.groupings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupings;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsV2Copier.copy(groupings);
        }

        @Override
        public final Builder groupings(Collection<String> groupings) {
            this.groupings = GroupingsV2Copier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(String ... groupings) {
            this.groupings(Arrays.asList(groupings));
            return this;
        }

        public final List<MetricV2.Builder> getMetrics() {
            List<MetricV2.Builder> result = MetricsV2Copier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<MetricV2.BuilderImpl> metrics) {
            this.metrics = MetricsV2Copier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<MetricV2> metrics) {
            this.metrics = MetricsV2Copier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricV2 ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricV2.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricV2)((MetricV2.Builder)MetricV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataV2Request build() {
            return new GetMetricDataV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataV2Request> {
        public Builder resourceArn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder interval(IntervalDetails var1);

        default public Builder interval(Consumer<IntervalDetails.Builder> interval) {
            return this.interval((IntervalDetails)((IntervalDetails.Builder)IntervalDetails.builder().applyMutation(interval)).build());
        }

        public Builder filters(Collection<FilterV2> var1);

        public Builder filters(FilterV2 ... var1);

        public Builder filters(Consumer<FilterV2.Builder> ... var1);

        public Builder groupings(Collection<String> var1);

        public Builder groupings(String ... var1);

        public Builder metrics(Collection<MetricV2> var1);

        public Builder metrics(MetricV2 ... var1);

        public Builder metrics(Consumer<MetricV2.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

