/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Queue;
import software.amazon.awssdk.services.connect.model.SearchQueuesRequest;
import software.amazon.awssdk.services.connect.model.SearchQueuesResponse;

public class SearchQueuesIterable
implements SdkIterable<SearchQueuesResponse> {
    private final ConnectClient client;
    private final SearchQueuesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchQueuesIterable(ConnectClient client, SearchQueuesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchQueuesResponseFetcher();
    }

    public Iterator<SearchQueuesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Queue> queues() {
        Function<SearchQueuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.queues() != null) {
                return response.queues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchQueuesResponseFetcher
    implements SyncPageFetcher<SearchQueuesResponse> {
        private SearchQueuesResponseFetcher() {
        }

        public boolean hasNextPage(SearchQueuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchQueuesResponse nextPage(SearchQueuesResponse previousPage) {
            if (previousPage == null) {
                return SearchQueuesIterable.this.client.searchQueues(SearchQueuesIterable.this.firstRequest);
            }
            return SearchQueuesIterable.this.client.searchQueues((SearchQueuesRequest)((Object)SearchQueuesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

