/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsRequest;
import software.amazon.awssdk.services.connect.model.ListLambdaFunctionsResponse;

public class ListLambdaFunctionsPublisher
implements SdkPublisher<ListLambdaFunctionsResponse> {
    private final ConnectAsyncClient client;
    private final ListLambdaFunctionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLambdaFunctionsPublisher(ConnectAsyncClient client, ListLambdaFunctionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLambdaFunctionsPublisher(ConnectAsyncClient client, ListLambdaFunctionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLambdaFunctionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLambdaFunctionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> lambdaFunctions() {
        Function<ListLambdaFunctionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lambdaFunctions() != null) {
                return response.lambdaFunctions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLambdaFunctionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLambdaFunctionsResponseFetcher
    implements AsyncPageFetcher<ListLambdaFunctionsResponse> {
        private ListLambdaFunctionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLambdaFunctionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLambdaFunctionsResponse> nextPage(ListLambdaFunctionsResponse previousPage) {
            if (previousPage == null) {
                return ListLambdaFunctionsPublisher.this.client.listLambdaFunctions(ListLambdaFunctionsPublisher.this.firstRequest);
            }
            return ListLambdaFunctionsPublisher.this.client.listLambdaFunctions((ListLambdaFunctionsRequest)((Object)ListLambdaFunctionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

