/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.DefaultVocabulary;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesRequest;
import software.amazon.awssdk.services.connect.model.ListDefaultVocabulariesResponse;

public class ListDefaultVocabulariesIterable
implements SdkIterable<ListDefaultVocabulariesResponse> {
    private final ConnectClient client;
    private final ListDefaultVocabulariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDefaultVocabulariesIterable(ConnectClient client, ListDefaultVocabulariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDefaultVocabulariesResponseFetcher();
    }

    public Iterator<ListDefaultVocabulariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DefaultVocabulary> defaultVocabularyList() {
        Function<ListDefaultVocabulariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.defaultVocabularyList() != null) {
                return response.defaultVocabularyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDefaultVocabulariesResponseFetcher
    implements SyncPageFetcher<ListDefaultVocabulariesResponse> {
        private ListDefaultVocabulariesResponseFetcher() {
        }

        public boolean hasNextPage(ListDefaultVocabulariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDefaultVocabulariesResponse nextPage(ListDefaultVocabulariesResponse previousPage) {
            if (previousPage == null) {
                return ListDefaultVocabulariesIterable.this.client.listDefaultVocabularies(ListDefaultVocabulariesIterable.this.firstRequest);
            }
            return ListDefaultVocabulariesIterable.this.client.listDefaultVocabularies((ListDefaultVocabulariesRequest)((Object)ListDefaultVocabulariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

