/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.InvisibleFieldInfo;
import software.amazon.awssdk.services.connect.model.InvisibleTaskTemplateFieldsCopier;
import software.amazon.awssdk.services.connect.model.ReadOnlyFieldInfo;
import software.amazon.awssdk.services.connect.model.ReadOnlyTaskTemplateFieldsCopier;
import software.amazon.awssdk.services.connect.model.RequiredFieldInfo;
import software.amazon.awssdk.services.connect.model.RequiredTaskTemplateFieldsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskTemplateConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskTemplateConstraints> {
    private static final SdkField<List<RequiredFieldInfo>> REQUIRED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredFields").getter(TaskTemplateConstraints.getter(TaskTemplateConstraints::requiredFields)).setter(TaskTemplateConstraints.setter(Builder::requiredFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequiredFieldInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ReadOnlyFieldInfo>> READ_ONLY_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadOnlyFields").getter(TaskTemplateConstraints.getter(TaskTemplateConstraints::readOnlyFields)).setter(TaskTemplateConstraints.setter(Builder::readOnlyFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnlyFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReadOnlyFieldInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InvisibleFieldInfo>> INVISIBLE_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InvisibleFields").getter(TaskTemplateConstraints.getter(TaskTemplateConstraints::invisibleFields)).setter(TaskTemplateConstraints.setter(Builder::invisibleFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvisibleFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvisibleFieldInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_FIELDS_FIELD, READ_ONLY_FIELDS_FIELD, INVISIBLE_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskTemplateConstraints.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RequiredFieldInfo> requiredFields;
    private final List<ReadOnlyFieldInfo> readOnlyFields;
    private final List<InvisibleFieldInfo> invisibleFields;

    private TaskTemplateConstraints(BuilderImpl builder) {
        this.requiredFields = builder.requiredFields;
        this.readOnlyFields = builder.readOnlyFields;
        this.invisibleFields = builder.invisibleFields;
    }

    public final boolean hasRequiredFields() {
        return this.requiredFields != null && !(this.requiredFields instanceof SdkAutoConstructList);
    }

    public final List<RequiredFieldInfo> requiredFields() {
        return this.requiredFields;
    }

    public final boolean hasReadOnlyFields() {
        return this.readOnlyFields != null && !(this.readOnlyFields instanceof SdkAutoConstructList);
    }

    public final List<ReadOnlyFieldInfo> readOnlyFields() {
        return this.readOnlyFields;
    }

    public final boolean hasInvisibleFields() {
        return this.invisibleFields != null && !(this.invisibleFields instanceof SdkAutoConstructList);
    }

    public final List<InvisibleFieldInfo> invisibleFields() {
        return this.invisibleFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFields() ? this.requiredFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadOnlyFields() ? this.readOnlyFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvisibleFields() ? this.invisibleFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskTemplateConstraints)) {
            return false;
        }
        TaskTemplateConstraints other = (TaskTemplateConstraints)obj;
        return this.hasRequiredFields() == other.hasRequiredFields() && Objects.equals(this.requiredFields(), other.requiredFields()) && this.hasReadOnlyFields() == other.hasReadOnlyFields() && Objects.equals(this.readOnlyFields(), other.readOnlyFields()) && this.hasInvisibleFields() == other.hasInvisibleFields() && Objects.equals(this.invisibleFields(), other.invisibleFields());
    }

    public final String toString() {
        return ToString.builder((String)"TaskTemplateConstraints").add("RequiredFields", this.hasRequiredFields() ? this.requiredFields() : null).add("ReadOnlyFields", this.hasReadOnlyFields() ? this.readOnlyFields() : null).add("InvisibleFields", this.hasInvisibleFields() ? this.invisibleFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequiredFields": {
                return Optional.ofNullable(clazz.cast(this.requiredFields()));
            }
            case "ReadOnlyFields": {
                return Optional.ofNullable(clazz.cast(this.readOnlyFields()));
            }
            case "InvisibleFields": {
                return Optional.ofNullable(clazz.cast(this.invisibleFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RequiredFields", REQUIRED_FIELDS_FIELD);
        map.put("ReadOnlyFields", READ_ONLY_FIELDS_FIELD);
        map.put("InvisibleFields", INVISIBLE_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskTemplateConstraints, T> g) {
        return obj -> g.apply((TaskTemplateConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RequiredFieldInfo> requiredFields = DefaultSdkAutoConstructList.getInstance();
        private List<ReadOnlyFieldInfo> readOnlyFields = DefaultSdkAutoConstructList.getInstance();
        private List<InvisibleFieldInfo> invisibleFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskTemplateConstraints model) {
            this.requiredFields(model.requiredFields);
            this.readOnlyFields(model.readOnlyFields);
            this.invisibleFields(model.invisibleFields);
        }

        public final List<RequiredFieldInfo.Builder> getRequiredFields() {
            List<RequiredFieldInfo.Builder> result = RequiredTaskTemplateFieldsCopier.copyToBuilder(this.requiredFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredFields(Collection<RequiredFieldInfo.BuilderImpl> requiredFields) {
            this.requiredFields = RequiredTaskTemplateFieldsCopier.copyFromBuilder(requiredFields);
        }

        @Override
        public final Builder requiredFields(Collection<RequiredFieldInfo> requiredFields) {
            this.requiredFields = RequiredTaskTemplateFieldsCopier.copy(requiredFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(RequiredFieldInfo ... requiredFields) {
            this.requiredFields(Arrays.asList(requiredFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(Consumer<RequiredFieldInfo.Builder> ... requiredFields) {
            this.requiredFields(Stream.of(requiredFields).map(c -> (RequiredFieldInfo)((RequiredFieldInfo.Builder)RequiredFieldInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ReadOnlyFieldInfo.Builder> getReadOnlyFields() {
            List<ReadOnlyFieldInfo.Builder> result = ReadOnlyTaskTemplateFieldsCopier.copyToBuilder(this.readOnlyFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadOnlyFields(Collection<ReadOnlyFieldInfo.BuilderImpl> readOnlyFields) {
            this.readOnlyFields = ReadOnlyTaskTemplateFieldsCopier.copyFromBuilder(readOnlyFields);
        }

        @Override
        public final Builder readOnlyFields(Collection<ReadOnlyFieldInfo> readOnlyFields) {
            this.readOnlyFields = ReadOnlyTaskTemplateFieldsCopier.copy(readOnlyFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFields(ReadOnlyFieldInfo ... readOnlyFields) {
            this.readOnlyFields(Arrays.asList(readOnlyFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readOnlyFields(Consumer<ReadOnlyFieldInfo.Builder> ... readOnlyFields) {
            this.readOnlyFields(Stream.of(readOnlyFields).map(c -> (ReadOnlyFieldInfo)((ReadOnlyFieldInfo.Builder)ReadOnlyFieldInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InvisibleFieldInfo.Builder> getInvisibleFields() {
            List<InvisibleFieldInfo.Builder> result = InvisibleTaskTemplateFieldsCopier.copyToBuilder(this.invisibleFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvisibleFields(Collection<InvisibleFieldInfo.BuilderImpl> invisibleFields) {
            this.invisibleFields = InvisibleTaskTemplateFieldsCopier.copyFromBuilder(invisibleFields);
        }

        @Override
        public final Builder invisibleFields(Collection<InvisibleFieldInfo> invisibleFields) {
            this.invisibleFields = InvisibleTaskTemplateFieldsCopier.copy(invisibleFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invisibleFields(InvisibleFieldInfo ... invisibleFields) {
            this.invisibleFields(Arrays.asList(invisibleFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invisibleFields(Consumer<InvisibleFieldInfo.Builder> ... invisibleFields) {
            this.invisibleFields(Stream.of(invisibleFields).map(c -> (InvisibleFieldInfo)((InvisibleFieldInfo.Builder)InvisibleFieldInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TaskTemplateConstraints build() {
            return new TaskTemplateConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskTemplateConstraints> {
        public Builder requiredFields(Collection<RequiredFieldInfo> var1);

        public Builder requiredFields(RequiredFieldInfo ... var1);

        public Builder requiredFields(Consumer<RequiredFieldInfo.Builder> ... var1);

        public Builder readOnlyFields(Collection<ReadOnlyFieldInfo> var1);

        public Builder readOnlyFields(ReadOnlyFieldInfo ... var1);

        public Builder readOnlyFields(Consumer<ReadOnlyFieldInfo.Builder> ... var1);

        public Builder invisibleFields(Collection<InvisibleFieldInfo> var1);

        public Builder invisibleFields(InvisibleFieldInfo ... var1);

        public Builder invisibleFields(Consumer<InvisibleFieldInfo.Builder> ... var1);
    }
}

