/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AllowedMonitorCapabilitiesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.MonitorCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitorContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, MonitorContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(MonitorContactRequest.getter(MonitorContactRequest::instanceId)).setter(MonitorContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(MonitorContactRequest.getter(MonitorContactRequest::contactId)).setter(MonitorContactRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(MonitorContactRequest.getter(MonitorContactRequest::userId)).setter(MonitorContactRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<List<String>> ALLOWED_MONITOR_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedMonitorCapabilities").getter(MonitorContactRequest.getter(MonitorContactRequest::allowedMonitorCapabilitiesAsStrings)).setter(MonitorContactRequest.setter(Builder::allowedMonitorCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedMonitorCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(MonitorContactRequest.getter(MonitorContactRequest::clientToken)).setter(MonitorContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, USER_ID_FIELD, ALLOWED_MONITOR_CAPABILITIES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MonitorContactRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactId;
    private final String userId;
    private final List<String> allowedMonitorCapabilities;
    private final String clientToken;

    private MonitorContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.userId = builder.userId;
        this.allowedMonitorCapabilities = builder.allowedMonitorCapabilities;
        this.clientToken = builder.clientToken;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String userId() {
        return this.userId;
    }

    public final List<MonitorCapability> allowedMonitorCapabilities() {
        return AllowedMonitorCapabilitiesCopier.copyStringToEnum(this.allowedMonitorCapabilities);
    }

    public final boolean hasAllowedMonitorCapabilities() {
        return this.allowedMonitorCapabilities != null && !(this.allowedMonitorCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> allowedMonitorCapabilitiesAsStrings() {
        return this.allowedMonitorCapabilities;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedMonitorCapabilities() ? this.allowedMonitorCapabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorContactRequest)) {
            return false;
        }
        MonitorContactRequest other = (MonitorContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.userId(), other.userId()) && this.hasAllowedMonitorCapabilities() == other.hasAllowedMonitorCapabilities() && Objects.equals(this.allowedMonitorCapabilitiesAsStrings(), other.allowedMonitorCapabilitiesAsStrings()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"MonitorContactRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("UserId", (Object)this.userId()).add("AllowedMonitorCapabilities", this.hasAllowedMonitorCapabilities() ? this.allowedMonitorCapabilitiesAsStrings() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "AllowedMonitorCapabilities": {
                return Optional.ofNullable(clazz.cast(this.allowedMonitorCapabilitiesAsStrings()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("AllowedMonitorCapabilities", ALLOWED_MONITOR_CAPABILITIES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonitorContactRequest, T> g) {
        return obj -> g.apply((MonitorContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private String userId;
        private List<String> allowedMonitorCapabilities = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.userId(model.userId);
            this.allowedMonitorCapabilitiesWithStrings(model.allowedMonitorCapabilities);
            this.clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Collection<String> getAllowedMonitorCapabilities() {
            if (this.allowedMonitorCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedMonitorCapabilities;
        }

        public final void setAllowedMonitorCapabilities(Collection<String> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copy(allowedMonitorCapabilities);
        }

        @Override
        public final Builder allowedMonitorCapabilitiesWithStrings(Collection<String> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copy(allowedMonitorCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMonitorCapabilitiesWithStrings(String ... allowedMonitorCapabilities) {
            this.allowedMonitorCapabilitiesWithStrings(Arrays.asList(allowedMonitorCapabilities));
            return this;
        }

        @Override
        public final Builder allowedMonitorCapabilities(Collection<MonitorCapability> allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities = AllowedMonitorCapabilitiesCopier.copyEnumToString(allowedMonitorCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedMonitorCapabilities(MonitorCapability ... allowedMonitorCapabilities) {
            this.allowedMonitorCapabilities(Arrays.asList(allowedMonitorCapabilities));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public MonitorContactRequest build() {
            return new MonitorContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, MonitorContactRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder userId(String var1);

        public Builder allowedMonitorCapabilitiesWithStrings(Collection<String> var1);

        public Builder allowedMonitorCapabilitiesWithStrings(String ... var1);

        public Builder allowedMonitorCapabilities(Collection<MonitorCapability> var1);

        public Builder allowedMonitorCapabilities(MonitorCapability ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

