/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersV2Response
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListPhoneNumbersV2Response> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumbersV2Response.getter(ListPhoneNumbersV2Response::nextToken)).setter(ListPhoneNumbersV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListPhoneNumbersSummary>> LIST_PHONE_NUMBERS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ListPhoneNumbersSummaryList").getter(ListPhoneNumbersV2Response.getter(ListPhoneNumbersV2Response::listPhoneNumbersSummaryList)).setter(ListPhoneNumbersV2Response.setter(Builder::listPhoneNumbersSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListPhoneNumbersSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListPhoneNumbersSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, LIST_PHONE_NUMBERS_SUMMARY_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPhoneNumbersV2Response.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList;

    private ListPhoneNumbersV2Response(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.listPhoneNumbersSummaryList = builder.listPhoneNumbersSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasListPhoneNumbersSummaryList() {
        return this.listPhoneNumbersSummaryList != null && !(this.listPhoneNumbersSummaryList instanceof SdkAutoConstructList);
    }

    public final List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList() {
        return this.listPhoneNumbersSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListPhoneNumbersSummaryList() ? this.listPhoneNumbersSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersV2Response)) {
            return false;
        }
        ListPhoneNumbersV2Response other = (ListPhoneNumbersV2Response)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasListPhoneNumbersSummaryList() == other.hasListPhoneNumbersSummaryList() && Objects.equals(this.listPhoneNumbersSummaryList(), other.listPhoneNumbersSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersV2Response").add("NextToken", (Object)this.nextToken()).add("ListPhoneNumbersSummaryList", this.hasListPhoneNumbersSummaryList() ? this.listPhoneNumbersSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ListPhoneNumbersSummaryList": {
                return Optional.ofNullable(clazz.cast(this.listPhoneNumbersSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ListPhoneNumbersSummaryList", LIST_PHONE_NUMBERS_SUMMARY_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersV2Response, T> g) {
        return obj -> g.apply((ListPhoneNumbersV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListPhoneNumbersSummary> listPhoneNumbersSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersV2Response model) {
            super(model);
            this.nextToken(model.nextToken);
            this.listPhoneNumbersSummaryList(model.listPhoneNumbersSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListPhoneNumbersSummary.Builder> getListPhoneNumbersSummaryList() {
            List<ListPhoneNumbersSummary.Builder> result = ListPhoneNumbersSummaryListCopier.copyToBuilder(this.listPhoneNumbersSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListPhoneNumbersSummaryList(Collection<ListPhoneNumbersSummary.BuilderImpl> listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList = ListPhoneNumbersSummaryListCopier.copyFromBuilder(listPhoneNumbersSummaryList);
        }

        @Override
        public final Builder listPhoneNumbersSummaryList(Collection<ListPhoneNumbersSummary> listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList = ListPhoneNumbersSummaryListCopier.copy(listPhoneNumbersSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listPhoneNumbersSummaryList(ListPhoneNumbersSummary ... listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList(Arrays.asList(listPhoneNumbersSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listPhoneNumbersSummaryList(Consumer<ListPhoneNumbersSummary.Builder> ... listPhoneNumbersSummaryList) {
            this.listPhoneNumbersSummaryList(Stream.of(listPhoneNumbersSummaryList).map(c -> (ListPhoneNumbersSummary)((ListPhoneNumbersSummary.Builder)ListPhoneNumbersSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPhoneNumbersV2Response build() {
            return new ListPhoneNumbersV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersV2Response> {
        public Builder nextToken(String var1);

        public Builder listPhoneNumbersSummaryList(Collection<ListPhoneNumbersSummary> var1);

        public Builder listPhoneNumbersSummaryList(ListPhoneNumbersSummary ... var1);

        public Builder listPhoneNumbersSummaryList(Consumer<ListPhoneNumbersSummary.Builder> ... var1);
    }
}

