/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.DeviceInfo;
import software.amazon.awssdk.services.connect.model.ParticipantCapabilities;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Customer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Customer> {
    private static final SdkField<DeviceInfo> DEVICE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceInfo").getter(Customer.getter(Customer::deviceInfo)).setter(Customer.setter(Builder::deviceInfo)).constructor(DeviceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceInfo").build()}).build();
    private static final SdkField<ParticipantCapabilities> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Capabilities").getter(Customer.getter(Customer::capabilities)).setter(Customer.setter(Builder::capabilities)).constructor(ParticipantCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_INFO_FIELD, CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Customer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DeviceInfo deviceInfo;
    private final ParticipantCapabilities capabilities;

    private Customer(BuilderImpl builder) {
        this.deviceInfo = builder.deviceInfo;
        this.capabilities = builder.capabilities;
    }

    public final DeviceInfo deviceInfo() {
        return this.deviceInfo;
    }

    public final ParticipantCapabilities capabilities() {
        return this.capabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilities());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Customer)) {
            return false;
        }
        Customer other = (Customer)obj;
        return Objects.equals(this.deviceInfo(), other.deviceInfo()) && Objects.equals(this.capabilities(), other.capabilities());
    }

    public final String toString() {
        return ToString.builder((String)"Customer").add("DeviceInfo", (Object)this.deviceInfo()).add("Capabilities", (Object)this.capabilities()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceInfo": {
                return Optional.ofNullable(clazz.cast(this.deviceInfo()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceInfo", DEVICE_INFO_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Customer, T> g) {
        return obj -> g.apply((Customer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeviceInfo deviceInfo;
        private ParticipantCapabilities capabilities;

        private BuilderImpl() {
        }

        private BuilderImpl(Customer model) {
            this.deviceInfo(model.deviceInfo);
            this.capabilities(model.capabilities);
        }

        public final DeviceInfo.Builder getDeviceInfo() {
            return this.deviceInfo != null ? this.deviceInfo.toBuilder() : null;
        }

        public final void setDeviceInfo(DeviceInfo.BuilderImpl deviceInfo) {
            this.deviceInfo = deviceInfo != null ? deviceInfo.build() : null;
        }

        @Override
        public final Builder deviceInfo(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public final ParticipantCapabilities.Builder getCapabilities() {
            return this.capabilities != null ? this.capabilities.toBuilder() : null;
        }

        public final void setCapabilities(ParticipantCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(ParticipantCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Customer build() {
            return new Customer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Customer> {
        public Builder deviceInfo(DeviceInfo var1);

        default public Builder deviceInfo(Consumer<DeviceInfo.Builder> deviceInfo) {
            return this.deviceInfo((DeviceInfo)((DeviceInfo.Builder)DeviceInfo.builder().applyMutation(deviceInfo)).build());
        }

        public Builder capabilities(ParticipantCapabilities var1);

        default public Builder capabilities(Consumer<ParticipantCapabilities.Builder> capabilities) {
            return this.capabilities((ParticipantCapabilities)((ParticipantCapabilities.Builder)ParticipantCapabilities.builder().applyMutation(capabilities)).build());
        }
    }
}

