/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.InitiateAs;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.UserInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateContactRequest.getter(CreateContactRequest::instanceId)).setter(CreateContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateContactRequest.getter(CreateContactRequest::clientToken)).setter(CreateContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(CreateContactRequest.getter(CreateContactRequest::relatedContactId)).setter(CreateContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(CreateContactRequest.getter(CreateContactRequest::attributes)).setter(CreateContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(CreateContactRequest.getter(CreateContactRequest::references)).setter(CreateContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(CreateContactRequest.getter(CreateContactRequest::channelAsString)).setter(CreateContactRequest.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(CreateContactRequest.getter(CreateContactRequest::initiationMethodAsString)).setter(CreateContactRequest.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<Integer> EXPIRY_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpiryDurationInMinutes").getter(CreateContactRequest.getter(CreateContactRequest::expiryDurationInMinutes)).setter(CreateContactRequest.setter(Builder::expiryDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDurationInMinutes").build()}).build();
    private static final SdkField<UserInfo> USER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserInfo").getter(CreateContactRequest.getter(CreateContactRequest::userInfo)).setter(CreateContactRequest.setter(Builder::userInfo)).constructor(UserInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfo").build()}).build();
    private static final SdkField<String> INITIATE_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiateAs").getter(CreateContactRequest.getter(CreateContactRequest::initiateAsAsString)).setter(CreateContactRequest.setter(Builder::initiateAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiateAs").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateContactRequest.getter(CreateContactRequest::name)).setter(CreateContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateContactRequest.getter(CreateContactRequest::description)).setter(CreateContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(CreateContactRequest.getter(CreateContactRequest::segmentAttributes)).setter(CreateContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PREVIOUS_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousContactId").getter(CreateContactRequest.getter(CreateContactRequest::previousContactId)).setter(CreateContactRequest.setter(Builder::previousContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousContactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD, RELATED_CONTACT_ID_FIELD, ATTRIBUTES_FIELD, REFERENCES_FIELD, CHANNEL_FIELD, INITIATION_METHOD_FIELD, EXPIRY_DURATION_IN_MINUTES_FIELD, USER_INFO_FIELD, INITIATE_AS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, SEGMENT_ATTRIBUTES_FIELD, PREVIOUS_CONTACT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateContactRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String clientToken;
    private final String relatedContactId;
    private final Map<String, String> attributes;
    private final Map<String, Reference> references;
    private final String channel;
    private final String initiationMethod;
    private final Integer expiryDurationInMinutes;
    private final UserInfo userInfo;
    private final String initiateAs;
    private final String name;
    private final String description;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final String previousContactId;

    private CreateContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.relatedContactId = builder.relatedContactId;
        this.attributes = builder.attributes;
        this.references = builder.references;
        this.channel = builder.channel;
        this.initiationMethod = builder.initiationMethod;
        this.expiryDurationInMinutes = builder.expiryDurationInMinutes;
        this.userInfo = builder.userInfo;
        this.initiateAs = builder.initiateAs;
        this.name = builder.name;
        this.description = builder.description;
        this.segmentAttributes = builder.segmentAttributes;
        this.previousContactId = builder.previousContactId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final Integer expiryDurationInMinutes() {
        return this.expiryDurationInMinutes;
    }

    public final UserInfo userInfo() {
        return this.userInfo;
    }

    public final InitiateAs initiateAs() {
        return InitiateAs.fromValue(this.initiateAs);
    }

    public final String initiateAsAsString() {
        return this.initiateAs;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final String previousContactId() {
        return this.previousContactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiateAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.previousContactId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactRequest)) {
            return false;
        }
        CreateContactRequest other = (CreateContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.expiryDurationInMinutes(), other.expiryDurationInMinutes()) && Objects.equals(this.userInfo(), other.userInfo()) && Objects.equals(this.initiateAsAsString(), other.initiateAsAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && Objects.equals(this.previousContactId(), other.previousContactId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactRequest").add("InstanceId", (Object)this.instanceId()).add("ClientToken", (Object)this.clientToken()).add("RelatedContactId", (Object)this.relatedContactId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("References", this.hasReferences() ? this.references() : null).add("Channel", (Object)this.channelAsString()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("ExpiryDurationInMinutes", (Object)this.expiryDurationInMinutes()).add("UserInfo", (Object)this.userInfo()).add("InitiateAs", (Object)this.initiateAsAsString()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("PreviousContactId", (Object)this.previousContactId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "ExpiryDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.expiryDurationInMinutes()));
            }
            case "UserInfo": {
                return Optional.ofNullable(clazz.cast(this.userInfo()));
            }
            case "InitiateAs": {
                return Optional.ofNullable(clazz.cast(this.initiateAsAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "PreviousContactId": {
                return Optional.ofNullable(clazz.cast(this.previousContactId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("ExpiryDurationInMinutes", EXPIRY_DURATION_IN_MINUTES_FIELD);
        map.put("UserInfo", USER_INFO_FIELD);
        map.put("InitiateAs", INITIATE_AS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("PreviousContactId", PREVIOUS_CONTACT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContactRequest, T> g) {
        return obj -> g.apply((CreateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String clientToken;
        private String relatedContactId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private String channel;
        private String initiationMethod;
        private Integer expiryDurationInMinutes;
        private UserInfo userInfo;
        private String initiateAs;
        private String name;
        private String description;
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String previousContactId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.clientToken(model.clientToken);
            this.relatedContactId(model.relatedContactId);
            this.attributes(model.attributes);
            this.references(model.references);
            this.channel(model.channel);
            this.initiationMethod(model.initiationMethod);
            this.expiryDurationInMinutes(model.expiryDurationInMinutes);
            this.userInfo(model.userInfo);
            this.initiateAs(model.initiateAs);
            this.name(model.name);
            this.description(model.description);
            this.segmentAttributes(model.segmentAttributes);
            this.previousContactId(model.previousContactId);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final Integer getExpiryDurationInMinutes() {
            return this.expiryDurationInMinutes;
        }

        public final void setExpiryDurationInMinutes(Integer expiryDurationInMinutes) {
            this.expiryDurationInMinutes = expiryDurationInMinutes;
        }

        @Override
        public final Builder expiryDurationInMinutes(Integer expiryDurationInMinutes) {
            this.expiryDurationInMinutes = expiryDurationInMinutes;
            return this;
        }

        public final UserInfo.Builder getUserInfo() {
            return this.userInfo != null ? this.userInfo.toBuilder() : null;
        }

        public final void setUserInfo(UserInfo.BuilderImpl userInfo) {
            this.userInfo = userInfo != null ? userInfo.build() : null;
        }

        @Override
        public final Builder userInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public final String getInitiateAs() {
            return this.initiateAs;
        }

        public final void setInitiateAs(String initiateAs) {
            this.initiateAs = initiateAs;
        }

        @Override
        public final Builder initiateAs(String initiateAs) {
            this.initiateAs = initiateAs;
            return this;
        }

        @Override
        public final Builder initiateAs(InitiateAs initiateAs) {
            this.initiateAs(initiateAs == null ? null : initiateAs.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final String getPreviousContactId() {
            return this.previousContactId;
        }

        public final void setPreviousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
        }

        @Override
        public final Builder previousContactId(String previousContactId) {
            this.previousContactId = previousContactId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateContactRequest build() {
            return new CreateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactRequest> {
        public Builder instanceId(String var1);

        public Builder clientToken(String var1);

        public Builder relatedContactId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder references(Map<String, Reference> var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder expiryDurationInMinutes(Integer var1);

        public Builder userInfo(UserInfo var1);

        default public Builder userInfo(Consumer<UserInfo.Builder> userInfo) {
            return this.userInfo((UserInfo)((UserInfo.Builder)UserInfo.builder().applyMutation(userInfo)).build());
        }

        public Builder initiateAs(String var1);

        public Builder initiateAs(InitiateAs var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder previousContactId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

