/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AttributeAndCondition;
import software.amazon.awssdk.services.connect.model.AttributeOrConditionListCopier;
import software.amazon.awssdk.services.connect.model.HierarchyGroupCondition;
import software.amazon.awssdk.services.connect.model.TagCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlPlaneUserAttributeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlPlaneUserAttributeFilter> {
    private static final SdkField<List<AttributeAndCondition>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ControlPlaneUserAttributeFilter.getter(ControlPlaneUserAttributeFilter::orConditions)).setter(ControlPlaneUserAttributeFilter.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttributeAndCondition> AND_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AndCondition").getter(ControlPlaneUserAttributeFilter.getter(ControlPlaneUserAttributeFilter::andCondition)).setter(ControlPlaneUserAttributeFilter.setter(Builder::andCondition)).constructor(AttributeAndCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndCondition").build()}).build();
    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TagCondition").getter(ControlPlaneUserAttributeFilter.getter(ControlPlaneUserAttributeFilter::tagCondition)).setter(ControlPlaneUserAttributeFilter.setter(Builder::tagCondition)).constructor(TagCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagCondition").build()}).build();
    private static final SdkField<HierarchyGroupCondition> HIERARCHY_GROUP_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HierarchyGroupCondition").getter(ControlPlaneUserAttributeFilter.getter(ControlPlaneUserAttributeFilter::hierarchyGroupCondition)).setter(ControlPlaneUserAttributeFilter.setter(Builder::hierarchyGroupCondition)).constructor(HierarchyGroupCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITION_FIELD, TAG_CONDITION_FIELD, HIERARCHY_GROUP_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ControlPlaneUserAttributeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AttributeAndCondition> orConditions;
    private final AttributeAndCondition andCondition;
    private final TagCondition tagCondition;
    private final HierarchyGroupCondition hierarchyGroupCondition;

    private ControlPlaneUserAttributeFilter(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andCondition = builder.andCondition;
        this.tagCondition = builder.tagCondition;
        this.hierarchyGroupCondition = builder.hierarchyGroupCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<AttributeAndCondition> orConditions() {
        return this.orConditions;
    }

    public final AttributeAndCondition andCondition() {
        return this.andCondition;
    }

    public final TagCondition tagCondition() {
        return this.tagCondition;
    }

    public final HierarchyGroupCondition hierarchyGroupCondition() {
        return this.hierarchyGroupCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.andCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupCondition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlPlaneUserAttributeFilter)) {
            return false;
        }
        ControlPlaneUserAttributeFilter other = (ControlPlaneUserAttributeFilter)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && Objects.equals(this.andCondition(), other.andCondition()) && Objects.equals(this.tagCondition(), other.tagCondition()) && Objects.equals(this.hierarchyGroupCondition(), other.hierarchyGroupCondition());
    }

    public final String toString() {
        return ToString.builder((String)"ControlPlaneUserAttributeFilter").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndCondition", (Object)this.andCondition()).add("TagCondition", (Object)this.tagCondition()).add("HierarchyGroupCondition", (Object)this.hierarchyGroupCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndCondition": {
                return Optional.ofNullable(clazz.cast(this.andCondition()));
            }
            case "TagCondition": {
                return Optional.ofNullable(clazz.cast(this.tagCondition()));
            }
            case "HierarchyGroupCondition": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupCondition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndCondition", AND_CONDITION_FIELD);
        map.put("TagCondition", TAG_CONDITION_FIELD);
        map.put("HierarchyGroupCondition", HIERARCHY_GROUP_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ControlPlaneUserAttributeFilter, T> g) {
        return obj -> g.apply((ControlPlaneUserAttributeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeAndCondition> orConditions = DefaultSdkAutoConstructList.getInstance();
        private AttributeAndCondition andCondition;
        private TagCondition tagCondition;
        private HierarchyGroupCondition hierarchyGroupCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlPlaneUserAttributeFilter model) {
            this.orConditions(model.orConditions);
            this.andCondition(model.andCondition);
            this.tagCondition(model.tagCondition);
            this.hierarchyGroupCondition(model.hierarchyGroupCondition);
        }

        public final List<AttributeAndCondition.Builder> getOrConditions() {
            List<AttributeAndCondition.Builder> result = AttributeOrConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<AttributeAndCondition.BuilderImpl> orConditions) {
            this.orConditions = AttributeOrConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<AttributeAndCondition> orConditions) {
            this.orConditions = AttributeOrConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(AttributeAndCondition ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<AttributeAndCondition.Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (AttributeAndCondition)((AttributeAndCondition.Builder)AttributeAndCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AttributeAndCondition.Builder getAndCondition() {
            return this.andCondition != null ? this.andCondition.toBuilder() : null;
        }

        public final void setAndCondition(AttributeAndCondition.BuilderImpl andCondition) {
            this.andCondition = andCondition != null ? andCondition.build() : null;
        }

        @Override
        public final Builder andCondition(AttributeAndCondition andCondition) {
            this.andCondition = andCondition;
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return this.tagCondition != null ? this.tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            this.tagCondition = tagCondition;
            return this;
        }

        public final HierarchyGroupCondition.Builder getHierarchyGroupCondition() {
            return this.hierarchyGroupCondition != null ? this.hierarchyGroupCondition.toBuilder() : null;
        }

        public final void setHierarchyGroupCondition(HierarchyGroupCondition.BuilderImpl hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition != null ? hierarchyGroupCondition.build() : null;
        }

        @Override
        public final Builder hierarchyGroupCondition(HierarchyGroupCondition hierarchyGroupCondition) {
            this.hierarchyGroupCondition = hierarchyGroupCondition;
            return this;
        }

        public ControlPlaneUserAttributeFilter build() {
            return new ControlPlaneUserAttributeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlPlaneUserAttributeFilter> {
        public Builder orConditions(Collection<AttributeAndCondition> var1);

        public Builder orConditions(AttributeAndCondition ... var1);

        public Builder orConditions(Consumer<AttributeAndCondition.Builder> ... var1);

        public Builder andCondition(AttributeAndCondition var1);

        default public Builder andCondition(Consumer<AttributeAndCondition.Builder> andCondition) {
            return this.andCondition((AttributeAndCondition)((AttributeAndCondition.Builder)AttributeAndCondition.builder().applyMutation(andCondition)).build());
        }

        public Builder tagCondition(TagCondition var1);

        default public Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return this.tagCondition((TagCondition)((TagCondition.Builder)TagCondition.builder().applyMutation(tagCondition)).build());
        }

        public Builder hierarchyGroupCondition(HierarchyGroupCondition var1);

        default public Builder hierarchyGroupCondition(Consumer<HierarchyGroupCondition.Builder> hierarchyGroupCondition) {
            return this.hierarchyGroupCondition((HierarchyGroupCondition)((HierarchyGroupCondition.Builder)HierarchyGroupCondition.builder().applyMutation(hierarchyGroupCondition)).build());
        }
    }
}

