/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregateResourceIdentifier;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;

public class ListAggregateDiscoveredResourcesPublisher
implements SdkPublisher<ListAggregateDiscoveredResourcesResponse> {
    private final ConfigAsyncClient client;
    private final ListAggregateDiscoveredResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAggregateDiscoveredResourcesPublisher(ConfigAsyncClient client, ListAggregateDiscoveredResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAggregateDiscoveredResourcesPublisher(ConfigAsyncClient client, ListAggregateDiscoveredResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAggregateDiscoveredResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAggregateDiscoveredResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregateResourceIdentifier> resourceIdentifiers() {
        return this.flatMapIterable(response -> response.resourceIdentifiers());
    }

    private class ListAggregateDiscoveredResourcesResponseFetcher
    implements AsyncPageFetcher<ListAggregateDiscoveredResourcesResponse> {
        private ListAggregateDiscoveredResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregateDiscoveredResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAggregateDiscoveredResourcesResponse> nextPage(ListAggregateDiscoveredResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregateDiscoveredResourcesPublisher.this.client.listAggregateDiscoveredResources(ListAggregateDiscoveredResourcesPublisher.this.firstRequest);
            }
            return ListAggregateDiscoveredResourcesPublisher.this.client.listAggregateDiscoveredResources((ListAggregateDiscoveredResourcesRequest)((Object)ListAggregateDiscoveredResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

