/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigurationItem;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;

public class GetResourceConfigHistoryPublisher
implements SdkPublisher<GetResourceConfigHistoryResponse> {
    private final ConfigAsyncClient client;
    private final GetResourceConfigHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourceConfigHistoryPublisher(ConfigAsyncClient client, GetResourceConfigHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourceConfigHistoryPublisher(ConfigAsyncClient client, GetResourceConfigHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourceConfigHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourceConfigHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationItem> configurationItems() {
        return this.flatMapIterable(response -> response.configurationItems());
    }

    private class GetResourceConfigHistoryResponseFetcher
    implements AsyncPageFetcher<GetResourceConfigHistoryResponse> {
        private GetResourceConfigHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetResourceConfigHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourceConfigHistoryResponse> nextPage(GetResourceConfigHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetResourceConfigHistoryPublisher.this.client.getResourceConfigHistory(GetResourceConfigHistoryPublisher.this.firstRequest);
            }
            return GetResourceConfigHistoryPublisher.this.client.getResourceConfigHistory((GetResourceConfigHistoryRequest)((Object)GetResourceConfigHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

