/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.PendingAggregationRequest;

public class DescribePendingAggregationRequestsPublisher
implements SdkPublisher<DescribePendingAggregationRequestsResponse> {
    private final ConfigAsyncClient client;
    private final DescribePendingAggregationRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePendingAggregationRequestsPublisher(ConfigAsyncClient client, DescribePendingAggregationRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePendingAggregationRequestsPublisher(ConfigAsyncClient client, DescribePendingAggregationRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePendingAggregationRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePendingAggregationRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PendingAggregationRequest> pendingAggregationRequests() {
        return this.flatMapIterable(response -> response.pendingAggregationRequests());
    }

    private class DescribePendingAggregationRequestsResponseFetcher
    implements AsyncPageFetcher<DescribePendingAggregationRequestsResponse> {
        private DescribePendingAggregationRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribePendingAggregationRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePendingAggregationRequestsResponse> nextPage(DescribePendingAggregationRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribePendingAggregationRequestsPublisher.this.client.describePendingAggregationRequests(DescribePendingAggregationRequestsPublisher.this.firstRequest);
            }
            return DescribePendingAggregationRequestsPublisher.this.client.describePendingAggregationRequests((DescribePendingAggregationRequestsRequest)((Object)DescribePendingAggregationRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

