/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregatedSourceStatus;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;

public class DescribeConfigurationAggregatorSourcesStatusPublisher
implements SdkPublisher<DescribeConfigurationAggregatorSourcesStatusResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConfigurationAggregatorSourcesStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigurationAggregatorSourcesStatusPublisher(ConfigAsyncClient client, DescribeConfigurationAggregatorSourcesStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigurationAggregatorSourcesStatusPublisher(ConfigAsyncClient client, DescribeConfigurationAggregatorSourcesStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigurationAggregatorSourcesStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigurationAggregatorSourcesStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregatedSourceStatus> aggregatedSourceStatusList() {
        return this.flatMapIterable(response -> response.aggregatedSourceStatusList());
    }

    private class DescribeConfigurationAggregatorSourcesStatusResponseFetcher
    implements AsyncPageFetcher<DescribeConfigurationAggregatorSourcesStatusResponse> {
        private DescribeConfigurationAggregatorSourcesStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigurationAggregatorSourcesStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> nextPage(DescribeConfigurationAggregatorSourcesStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigurationAggregatorSourcesStatusPublisher.this.client.describeConfigurationAggregatorSourcesStatus(DescribeConfigurationAggregatorSourcesStatusPublisher.this.firstRequest);
            }
            return DescribeConfigurationAggregatorSourcesStatusPublisher.this.client.describeConfigurationAggregatorSourcesStatus((DescribeConfigurationAggregatorSourcesStatusRequest)((Object)DescribeConfigurationAggregatorSourcesStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

