/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    AWS_EC2_CUSTOMER_GATEWAY("AWS::EC2::CustomerGateway"),
    AWS_EC2_EIP("AWS::EC2::EIP"),
    AWS_EC2_HOST("AWS::EC2::Host"),
    AWS_EC2_INSTANCE("AWS::EC2::Instance"),
    AWS_EC2_INTERNET_GATEWAY("AWS::EC2::InternetGateway"),
    AWS_EC2_NETWORK_ACL("AWS::EC2::NetworkAcl"),
    AWS_EC2_NETWORK_INTERFACE("AWS::EC2::NetworkInterface"),
    AWS_EC2_ROUTE_TABLE("AWS::EC2::RouteTable"),
    AWS_EC2_SECURITY_GROUP("AWS::EC2::SecurityGroup"),
    AWS_EC2_SUBNET("AWS::EC2::Subnet"),
    AWS_CLOUD_TRAIL_TRAIL("AWS::CloudTrail::Trail"),
    AWS_EC2_VOLUME("AWS::EC2::Volume"),
    AWS_EC2_VPC("AWS::EC2::VPC"),
    AWS_EC2_VPN_CONNECTION("AWS::EC2::VPNConnection"),
    AWS_EC2_VPN_GATEWAY("AWS::EC2::VPNGateway"),
    AWS_EC2_REGISTERED_HA_INSTANCE("AWS::EC2::RegisteredHAInstance"),
    AWS_EC2_NAT_GATEWAY("AWS::EC2::NatGateway"),
    AWS_EC2_EGRESS_ONLY_INTERNET_GATEWAY("AWS::EC2::EgressOnlyInternetGateway"),
    AWS_EC2_VPC_ENDPOINT("AWS::EC2::VPCEndpoint"),
    AWS_EC2_VPC_ENDPOINT_SERVICE("AWS::EC2::VPCEndpointService"),
    AWS_EC2_FLOW_LOG("AWS::EC2::FlowLog"),
    AWS_EC2_VPC_PEERING_CONNECTION("AWS::EC2::VPCPeeringConnection"),
    AWS_ELASTICSEARCH_DOMAIN("AWS::Elasticsearch::Domain"),
    AWS_IAM_GROUP("AWS::IAM::Group"),
    AWS_IAM_POLICY("AWS::IAM::Policy"),
    AWS_IAM_ROLE("AWS::IAM::Role"),
    AWS_IAM_USER("AWS::IAM::User"),
    AWS_ELASTIC_LOAD_BALANCING_V2_LOAD_BALANCER("AWS::ElasticLoadBalancingV2::LoadBalancer"),
    AWS_ACM_CERTIFICATE("AWS::ACM::Certificate"),
    AWS_RDS_DB_INSTANCE("AWS::RDS::DBInstance"),
    AWS_RDS_DB_SUBNET_GROUP("AWS::RDS::DBSubnetGroup"),
    AWS_RDS_DB_SECURITY_GROUP("AWS::RDS::DBSecurityGroup"),
    AWS_RDS_DB_SNAPSHOT("AWS::RDS::DBSnapshot"),
    AWS_RDS_DB_CLUSTER("AWS::RDS::DBCluster"),
    AWS_RDS_DB_CLUSTER_SNAPSHOT("AWS::RDS::DBClusterSnapshot"),
    AWS_RDS_EVENT_SUBSCRIPTION("AWS::RDS::EventSubscription"),
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_S3_ACCOUNT_PUBLIC_ACCESS_BLOCK("AWS::S3::AccountPublicAccessBlock"),
    AWS_REDSHIFT_CLUSTER("AWS::Redshift::Cluster"),
    AWS_REDSHIFT_CLUSTER_SNAPSHOT("AWS::Redshift::ClusterSnapshot"),
    AWS_REDSHIFT_CLUSTER_PARAMETER_GROUP("AWS::Redshift::ClusterParameterGroup"),
    AWS_REDSHIFT_CLUSTER_SECURITY_GROUP("AWS::Redshift::ClusterSecurityGroup"),
    AWS_REDSHIFT_CLUSTER_SUBNET_GROUP("AWS::Redshift::ClusterSubnetGroup"),
    AWS_REDSHIFT_EVENT_SUBSCRIPTION("AWS::Redshift::EventSubscription"),
    AWS_SSM_MANAGED_INSTANCE_INVENTORY("AWS::SSM::ManagedInstanceInventory"),
    AWS_CLOUD_WATCH_ALARM("AWS::CloudWatch::Alarm"),
    AWS_CLOUD_FORMATION_STACK("AWS::CloudFormation::Stack"),
    AWS_ELASTIC_LOAD_BALANCING_LOAD_BALANCER("AWS::ElasticLoadBalancing::LoadBalancer"),
    AWS_AUTO_SCALING_AUTO_SCALING_GROUP("AWS::AutoScaling::AutoScalingGroup"),
    AWS_AUTO_SCALING_LAUNCH_CONFIGURATION("AWS::AutoScaling::LaunchConfiguration"),
    AWS_AUTO_SCALING_SCALING_POLICY("AWS::AutoScaling::ScalingPolicy"),
    AWS_AUTO_SCALING_SCHEDULED_ACTION("AWS::AutoScaling::ScheduledAction"),
    AWS_DYNAMO_DB_TABLE("AWS::DynamoDB::Table"),
    AWS_CODE_BUILD_PROJECT("AWS::CodeBuild::Project"),
    AWS_WAF_RATE_BASED_RULE("AWS::WAF::RateBasedRule"),
    AWS_WAF_RULE("AWS::WAF::Rule"),
    AWS_WAF_RULE_GROUP("AWS::WAF::RuleGroup"),
    AWS_WAF_WEB_ACL("AWS::WAF::WebACL"),
    AWS_WAF_REGIONAL_RATE_BASED_RULE("AWS::WAFRegional::RateBasedRule"),
    AWS_WAF_REGIONAL_RULE("AWS::WAFRegional::Rule"),
    AWS_WAF_REGIONAL_RULE_GROUP("AWS::WAFRegional::RuleGroup"),
    AWS_WAF_REGIONAL_WEB_ACL("AWS::WAFRegional::WebACL"),
    AWS_CLOUD_FRONT_DISTRIBUTION("AWS::CloudFront::Distribution"),
    AWS_CLOUD_FRONT_STREAMING_DISTRIBUTION("AWS::CloudFront::StreamingDistribution"),
    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),
    AWS_NETWORK_FIREWALL_FIREWALL("AWS::NetworkFirewall::Firewall"),
    AWS_NETWORK_FIREWALL_FIREWALL_POLICY("AWS::NetworkFirewall::FirewallPolicy"),
    AWS_NETWORK_FIREWALL_RULE_GROUP("AWS::NetworkFirewall::RuleGroup"),
    AWS_ELASTIC_BEANSTALK_APPLICATION("AWS::ElasticBeanstalk::Application"),
    AWS_ELASTIC_BEANSTALK_APPLICATION_VERSION("AWS::ElasticBeanstalk::ApplicationVersion"),
    AWS_ELASTIC_BEANSTALK_ENVIRONMENT("AWS::ElasticBeanstalk::Environment"),
    AWS_WAF_V2_WEB_ACL("AWS::WAFv2::WebACL"),
    AWS_WAF_V2_RULE_GROUP("AWS::WAFv2::RuleGroup"),
    AWS_WAF_V2_IP_SET("AWS::WAFv2::IPSet"),
    AWS_WAF_V2_REGEX_PATTERN_SET("AWS::WAFv2::RegexPatternSet"),
    AWS_WAF_V2_MANAGED_RULE_SET("AWS::WAFv2::ManagedRuleSet"),
    AWS_X_RAY_ENCRYPTION_CONFIG("AWS::XRay::EncryptionConfig"),
    AWS_SSM_ASSOCIATION_COMPLIANCE("AWS::SSM::AssociationCompliance"),
    AWS_SSM_PATCH_COMPLIANCE("AWS::SSM::PatchCompliance"),
    AWS_SHIELD_PROTECTION("AWS::Shield::Protection"),
    AWS_SHIELD_REGIONAL_PROTECTION("AWS::ShieldRegional::Protection"),
    AWS_CONFIG_CONFORMANCE_PACK_COMPLIANCE("AWS::Config::ConformancePackCompliance"),
    AWS_CONFIG_RESOURCE_COMPLIANCE("AWS::Config::ResourceCompliance"),
    AWS_API_GATEWAY_STAGE("AWS::ApiGateway::Stage"),
    AWS_API_GATEWAY_REST_API("AWS::ApiGateway::RestApi"),
    AWS_API_GATEWAY_V2_STAGE("AWS::ApiGatewayV2::Stage"),
    AWS_API_GATEWAY_V2_API("AWS::ApiGatewayV2::Api"),
    AWS_CODE_PIPELINE_PIPELINE("AWS::CodePipeline::Pipeline"),
    AWS_SERVICE_CATALOG_CLOUD_FORMATION_PROVISIONED_PRODUCT("AWS::ServiceCatalog::CloudFormationProvisionedProduct"),
    AWS_SERVICE_CATALOG_CLOUD_FORMATION_PRODUCT("AWS::ServiceCatalog::CloudFormationProduct"),
    AWS_SERVICE_CATALOG_PORTFOLIO("AWS::ServiceCatalog::Portfolio"),
    AWS_SQS_QUEUE("AWS::SQS::Queue"),
    AWS_KMS_KEY("AWS::KMS::Key"),
    AWS_QLDB_LEDGER("AWS::QLDB::Ledger"),
    AWS_SECRETS_MANAGER_SECRET("AWS::SecretsManager::Secret"),
    AWS_SNS_TOPIC("AWS::SNS::Topic"),
    AWS_SSM_FILE_DATA("AWS::SSM::FileData"),
    AWS_BACKUP_BACKUP_PLAN("AWS::Backup::BackupPlan"),
    AWS_BACKUP_BACKUP_SELECTION("AWS::Backup::BackupSelection"),
    AWS_BACKUP_BACKUP_VAULT("AWS::Backup::BackupVault"),
    AWS_BACKUP_RECOVERY_POINT("AWS::Backup::RecoveryPoint"),
    AWS_ECR_REPOSITORY("AWS::ECR::Repository"),
    AWS_ECS_CLUSTER("AWS::ECS::Cluster"),
    AWS_ECS_SERVICE("AWS::ECS::Service"),
    AWS_ECS_TASK_DEFINITION("AWS::ECS::TaskDefinition"),
    AWS_EFS_ACCESS_POINT("AWS::EFS::AccessPoint"),
    AWS_EFS_FILE_SYSTEM("AWS::EFS::FileSystem"),
    AWS_EKS_CLUSTER("AWS::EKS::Cluster"),
    AWS_OPEN_SEARCH_DOMAIN("AWS::OpenSearch::Domain"),
    AWS_EC2_TRANSIT_GATEWAY("AWS::EC2::TransitGateway"),
    AWS_KINESIS_STREAM("AWS::Kinesis::Stream"),
    AWS_KINESIS_STREAM_CONSUMER("AWS::Kinesis::StreamConsumer"),
    AWS_CODE_DEPLOY_APPLICATION("AWS::CodeDeploy::Application"),
    AWS_CODE_DEPLOY_DEPLOYMENT_CONFIG("AWS::CodeDeploy::DeploymentConfig"),
    AWS_CODE_DEPLOY_DEPLOYMENT_GROUP("AWS::CodeDeploy::DeploymentGroup"),
    AWS_EC2_LAUNCH_TEMPLATE("AWS::EC2::LaunchTemplate"),
    AWS_ECR_PUBLIC_REPOSITORY("AWS::ECR::PublicRepository"),
    AWS_GUARD_DUTY_DETECTOR("AWS::GuardDuty::Detector"),
    AWS_EMR_SECURITY_CONFIGURATION("AWS::EMR::SecurityConfiguration"),
    AWS_SAGE_MAKER_CODE_REPOSITORY("AWS::SageMaker::CodeRepository"),
    AWS_ROUTE53_RESOLVER_RESOLVER_ENDPOINT("AWS::Route53Resolver::ResolverEndpoint"),
    AWS_ROUTE53_RESOLVER_RESOLVER_RULE("AWS::Route53Resolver::ResolverRule"),
    AWS_ROUTE53_RESOLVER_RESOLVER_RULE_ASSOCIATION("AWS::Route53Resolver::ResolverRuleAssociation"),
    AWS_DMS_REPLICATION_SUBNET_GROUP("AWS::DMS::ReplicationSubnetGroup"),
    AWS_DMS_EVENT_SUBSCRIPTION("AWS::DMS::EventSubscription"),
    AWS_MSK_CLUSTER("AWS::MSK::Cluster"),
    AWS_STEP_FUNCTIONS_ACTIVITY("AWS::StepFunctions::Activity"),
    AWS_WORK_SPACES_WORKSPACE("AWS::WorkSpaces::Workspace"),
    AWS_WORK_SPACES_CONNECTION_ALIAS("AWS::WorkSpaces::ConnectionAlias"),
    AWS_SAGE_MAKER_MODEL("AWS::SageMaker::Model"),
    AWS_ELASTIC_LOAD_BALANCING_V2_LISTENER("AWS::ElasticLoadBalancingV2::Listener"),
    AWS_STEP_FUNCTIONS_STATE_MACHINE("AWS::StepFunctions::StateMachine"),
    AWS_BATCH_JOB_QUEUE("AWS::Batch::JobQueue"),
    AWS_BATCH_COMPUTE_ENVIRONMENT("AWS::Batch::ComputeEnvironment"),
    AWS_ACCESS_ANALYZER_ANALYZER("AWS::AccessAnalyzer::Analyzer"),
    AWS_ATHENA_WORK_GROUP("AWS::Athena::WorkGroup"),
    AWS_ATHENA_DATA_CATALOG("AWS::Athena::DataCatalog"),
    AWS_DETECTIVE_GRAPH("AWS::Detective::Graph"),
    AWS_GLOBAL_ACCELERATOR_ACCELERATOR("AWS::GlobalAccelerator::Accelerator"),
    AWS_GLOBAL_ACCELERATOR_ENDPOINT_GROUP("AWS::GlobalAccelerator::EndpointGroup"),
    AWS_GLOBAL_ACCELERATOR_LISTENER("AWS::GlobalAccelerator::Listener"),
    AWS_EC2_TRANSIT_GATEWAY_ATTACHMENT("AWS::EC2::TransitGatewayAttachment"),
    AWS_EC2_TRANSIT_GATEWAY_ROUTE_TABLE("AWS::EC2::TransitGatewayRouteTable"),
    AWS_DMS_CERTIFICATE("AWS::DMS::Certificate"),
    AWS_APP_CONFIG_APPLICATION("AWS::AppConfig::Application"),
    AWS_APP_SYNC_GRAPH_QL_API("AWS::AppSync::GraphQLApi"),
    AWS_DATA_SYNC_LOCATION_SMB("AWS::DataSync::LocationSMB"),
    AWS_DATA_SYNC_LOCATION_F_SX_LUSTRE("AWS::DataSync::LocationFSxLustre"),
    AWS_DATA_SYNC_LOCATION_S3("AWS::DataSync::LocationS3"),
    AWS_DATA_SYNC_LOCATION_EFS("AWS::DataSync::LocationEFS"),
    AWS_DATA_SYNC_TASK("AWS::DataSync::Task"),
    AWS_DATA_SYNC_LOCATION_NFS("AWS::DataSync::LocationNFS"),
    AWS_EC2_NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS("AWS::EC2::NetworkInsightsAccessScopeAnalysis"),
    AWS_EKS_FARGATE_PROFILE("AWS::EKS::FargateProfile"),
    AWS_GLUE_JOB("AWS::Glue::Job"),
    AWS_GUARD_DUTY_THREAT_INTEL_SET("AWS::GuardDuty::ThreatIntelSet"),
    AWS_GUARD_DUTY_IP_SET("AWS::GuardDuty::IPSet"),
    AWS_SAGE_MAKER_WORKTEAM("AWS::SageMaker::Workteam"),
    AWS_SAGE_MAKER_NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG("AWS::SageMaker::NotebookInstanceLifecycleConfig"),
    AWS_SERVICE_DISCOVERY_SERVICE("AWS::ServiceDiscovery::Service"),
    AWS_SERVICE_DISCOVERY_PUBLIC_DNS_NAMESPACE("AWS::ServiceDiscovery::PublicDnsNamespace"),
    AWS_SES_CONTACT_LIST("AWS::SES::ContactList"),
    AWS_SES_CONFIGURATION_SET("AWS::SES::ConfigurationSet"),
    AWS_ROUTE53_HOSTED_ZONE("AWS::Route53::HostedZone"),
    AWS_IO_T_EVENTS_INPUT("AWS::IoTEvents::Input"),
    AWS_IO_T_EVENTS_DETECTOR_MODEL("AWS::IoTEvents::DetectorModel"),
    AWS_IO_T_EVENTS_ALARM_MODEL("AWS::IoTEvents::AlarmModel"),
    AWS_SERVICE_DISCOVERY_HTTP_NAMESPACE("AWS::ServiceDiscovery::HttpNamespace"),
    AWS_EVENTS_EVENT_BUS("AWS::Events::EventBus"),
    AWS_IMAGE_BUILDER_CONTAINER_RECIPE("AWS::ImageBuilder::ContainerRecipe"),
    AWS_IMAGE_BUILDER_DISTRIBUTION_CONFIGURATION("AWS::ImageBuilder::DistributionConfiguration"),
    AWS_IMAGE_BUILDER_INFRASTRUCTURE_CONFIGURATION("AWS::ImageBuilder::InfrastructureConfiguration"),
    AWS_DATA_SYNC_LOCATION_OBJECT_STORAGE("AWS::DataSync::LocationObjectStorage"),
    AWS_DATA_SYNC_LOCATION_HDFS("AWS::DataSync::LocationHDFS"),
    AWS_GLUE_CLASSIFIER("AWS::Glue::Classifier"),
    AWS_ROUTE53_RECOVERY_READINESS_CELL("AWS::Route53RecoveryReadiness::Cell"),
    AWS_ROUTE53_RECOVERY_READINESS_READINESS_CHECK("AWS::Route53RecoveryReadiness::ReadinessCheck"),
    AWS_ECR_REGISTRY_POLICY("AWS::ECR::RegistryPolicy"),
    AWS_BACKUP_REPORT_PLAN("AWS::Backup::ReportPlan"),
    AWS_LIGHTSAIL_CERTIFICATE("AWS::Lightsail::Certificate"),
    AWS_RUM_APP_MONITOR("AWS::RUM::AppMonitor"),
    AWS_EVENTS_ENDPOINT("AWS::Events::Endpoint"),
    AWS_SES_RECEIPT_RULE_SET("AWS::SES::ReceiptRuleSet"),
    AWS_EVENTS_ARCHIVE("AWS::Events::Archive"),
    AWS_EVENTS_API_DESTINATION("AWS::Events::ApiDestination"),
    AWS_LIGHTSAIL_DISK("AWS::Lightsail::Disk"),
    AWS_FIS_EXPERIMENT_TEMPLATE("AWS::FIS::ExperimentTemplate"),
    AWS_DATA_SYNC_LOCATION_F_SX_WINDOWS("AWS::DataSync::LocationFSxWindows"),
    AWS_SES_RECEIPT_FILTER("AWS::SES::ReceiptFilter"),
    AWS_GUARD_DUTY_FILTER("AWS::GuardDuty::Filter"),
    AWS_SES_TEMPLATE("AWS::SES::Template"),
    AWS_AMAZON_MQ_BROKER("AWS::AmazonMQ::Broker"),
    AWS_APP_CONFIG_ENVIRONMENT("AWS::AppConfig::Environment"),
    AWS_APP_CONFIG_CONFIGURATION_PROFILE("AWS::AppConfig::ConfigurationProfile"),
    AWS_CLOUD9_ENVIRONMENT_EC2("AWS::Cloud9::EnvironmentEC2"),
    AWS_EVENT_SCHEMAS_REGISTRY("AWS::EventSchemas::Registry"),
    AWS_EVENT_SCHEMAS_REGISTRY_POLICY("AWS::EventSchemas::RegistryPolicy"),
    AWS_EVENT_SCHEMAS_DISCOVERER("AWS::EventSchemas::Discoverer"),
    AWS_FRAUD_DETECTOR_LABEL("AWS::FraudDetector::Label"),
    AWS_FRAUD_DETECTOR_ENTITY_TYPE("AWS::FraudDetector::EntityType"),
    AWS_FRAUD_DETECTOR_VARIABLE("AWS::FraudDetector::Variable"),
    AWS_FRAUD_DETECTOR_OUTCOME("AWS::FraudDetector::Outcome"),
    AWS_IOT_AUTHORIZER("AWS::IoT::Authorizer"),
    AWS_IOT_SECURITY_PROFILE("AWS::IoT::SecurityProfile"),
    AWS_IOT_ROLE_ALIAS("AWS::IoT::RoleAlias"),
    AWS_IOT_DIMENSION("AWS::IoT::Dimension"),
    AWS_IO_T_ANALYTICS_DATASTORE("AWS::IoTAnalytics::Datastore"),
    AWS_LIGHTSAIL_BUCKET("AWS::Lightsail::Bucket"),
    AWS_LIGHTSAIL_STATIC_IP("AWS::Lightsail::StaticIp"),
    AWS_MEDIA_PACKAGE_PACKAGING_GROUP("AWS::MediaPackage::PackagingGroup"),
    AWS_ROUTE53_RECOVERY_READINESS_RECOVERY_GROUP("AWS::Route53RecoveryReadiness::RecoveryGroup"),
    AWS_RESILIENCE_HUB_RESILIENCY_POLICY("AWS::ResilienceHub::ResiliencyPolicy"),
    AWS_TRANSFER_WORKFLOW("AWS::Transfer::Workflow"),
    AWS_EKS_IDENTITY_PROVIDER_CONFIG("AWS::EKS::IdentityProviderConfig"),
    AWS_EKS_ADDON("AWS::EKS::Addon"),
    AWS_GLUE_ML_TRANSFORM("AWS::Glue::MLTransform"),
    AWS_IOT_POLICY("AWS::IoT::Policy"),
    AWS_IOT_MITIGATION_ACTION("AWS::IoT::MitigationAction"),
    AWS_IO_T_TWIN_MAKER_WORKSPACE("AWS::IoTTwinMaker::Workspace"),
    AWS_IO_T_TWIN_MAKER_ENTITY("AWS::IoTTwinMaker::Entity"),
    AWS_IO_T_ANALYTICS_DATASET("AWS::IoTAnalytics::Dataset"),
    AWS_IO_T_ANALYTICS_PIPELINE("AWS::IoTAnalytics::Pipeline"),
    AWS_IO_T_ANALYTICS_CHANNEL("AWS::IoTAnalytics::Channel"),
    AWS_IO_T_SITE_WISE_DASHBOARD("AWS::IoTSiteWise::Dashboard"),
    AWS_IO_T_SITE_WISE_PROJECT("AWS::IoTSiteWise::Project"),
    AWS_IO_T_SITE_WISE_PORTAL("AWS::IoTSiteWise::Portal"),
    AWS_IO_T_SITE_WISE_ASSET_MODEL("AWS::IoTSiteWise::AssetModel"),
    AWS_IVS_CHANNEL("AWS::IVS::Channel"),
    AWS_IVS_RECORDING_CONFIGURATION("AWS::IVS::RecordingConfiguration"),
    AWS_IVS_PLAYBACK_KEY_PAIR("AWS::IVS::PlaybackKeyPair"),
    AWS_KINESIS_ANALYTICS_V2_APPLICATION("AWS::KinesisAnalyticsV2::Application"),
    AWS_RDS_GLOBAL_CLUSTER("AWS::RDS::GlobalCluster"),
    AWS_S3_MULTI_REGION_ACCESS_POINT("AWS::S3::MultiRegionAccessPoint"),
    AWS_DEVICE_FARM_TEST_GRID_PROJECT("AWS::DeviceFarm::TestGridProject"),
    AWS_BUDGETS_BUDGETS_ACTION("AWS::Budgets::BudgetsAction"),
    AWS_LEX_BOT("AWS::Lex::Bot"),
    AWS_CODE_GURU_REVIEWER_REPOSITORY_ASSOCIATION("AWS::CodeGuruReviewer::RepositoryAssociation"),
    AWS_IOT_CUSTOM_METRIC("AWS::IoT::CustomMetric"),
    AWS_ROUTE53_RESOLVER_FIREWALL_DOMAIN_LIST("AWS::Route53Resolver::FirewallDomainList"),
    AWS_ROBO_MAKER_ROBOT_APPLICATION_VERSION("AWS::RoboMaker::RobotApplicationVersion"),
    AWS_EC2_TRAFFIC_MIRROR_SESSION("AWS::EC2::TrafficMirrorSession"),
    AWS_IO_T_SITE_WISE_GATEWAY("AWS::IoTSiteWise::Gateway"),
    AWS_LEX_BOT_ALIAS("AWS::Lex::BotAlias"),
    AWS_LOOKOUT_METRICS_ALERT("AWS::LookoutMetrics::Alert"),
    AWS_IOT_ACCOUNT_AUDIT_CONFIGURATION("AWS::IoT::AccountAuditConfiguration"),
    AWS_EC2_TRAFFIC_MIRROR_TARGET("AWS::EC2::TrafficMirrorTarget"),
    AWS_S3_STORAGE_LENS("AWS::S3::StorageLens"),
    AWS_IOT_SCHEDULED_AUDIT("AWS::IoT::ScheduledAudit"),
    AWS_EVENTS_CONNECTION("AWS::Events::Connection"),
    AWS_EVENT_SCHEMAS_SCHEMA("AWS::EventSchemas::Schema"),
    AWS_MEDIA_PACKAGE_PACKAGING_CONFIGURATION("AWS::MediaPackage::PackagingConfiguration"),
    AWS_KINESIS_VIDEO_SIGNALING_CHANNEL("AWS::KinesisVideo::SignalingChannel"),
    AWS_APP_STREAM_DIRECTORY_CONFIG("AWS::AppStream::DirectoryConfig"),
    AWS_LOOKOUT_VISION_PROJECT("AWS::LookoutVision::Project"),
    AWS_ROUTE53_RECOVERY_CONTROL_CLUSTER("AWS::Route53RecoveryControl::Cluster"),
    AWS_ROUTE53_RECOVERY_CONTROL_SAFETY_RULE("AWS::Route53RecoveryControl::SafetyRule"),
    AWS_ROUTE53_RECOVERY_CONTROL_CONTROL_PANEL("AWS::Route53RecoveryControl::ControlPanel"),
    AWS_ROUTE53_RECOVERY_CONTROL_ROUTING_CONTROL("AWS::Route53RecoveryControl::RoutingControl"),
    AWS_ROUTE53_RECOVERY_READINESS_RESOURCE_SET("AWS::Route53RecoveryReadiness::ResourceSet"),
    AWS_ROBO_MAKER_SIMULATION_APPLICATION("AWS::RoboMaker::SimulationApplication"),
    AWS_ROBO_MAKER_ROBOT_APPLICATION("AWS::RoboMaker::RobotApplication"),
    AWS_HEALTH_LAKE_FHIR_DATASTORE("AWS::HealthLake::FHIRDatastore"),
    AWS_PINPOINT_SEGMENT("AWS::Pinpoint::Segment"),
    AWS_PINPOINT_APPLICATION_SETTINGS("AWS::Pinpoint::ApplicationSettings"),
    AWS_EVENTS_RULE("AWS::Events::Rule"),
    AWS_EC2_DHCP_OPTIONS("AWS::EC2::DHCPOptions"),
    AWS_EC2_NETWORK_INSIGHTS_PATH("AWS::EC2::NetworkInsightsPath"),
    AWS_EC2_TRAFFIC_MIRROR_FILTER("AWS::EC2::TrafficMirrorFilter"),
    AWS_EC2_IPAM("AWS::EC2::IPAM"),
    AWS_IO_T_TWIN_MAKER_SCENE("AWS::IoTTwinMaker::Scene"),
    AWS_NETWORK_MANAGER_TRANSIT_GATEWAY_REGISTRATION("AWS::NetworkManager::TransitGatewayRegistration"),
    AWS_CUSTOMER_PROFILES_DOMAIN("AWS::CustomerProfiles::Domain"),
    AWS_AUTO_SCALING_WARM_POOL("AWS::AutoScaling::WarmPool"),
    AWS_CONNECT_PHONE_NUMBER("AWS::Connect::PhoneNumber"),
    AWS_APP_CONFIG_DEPLOYMENT_STRATEGY("AWS::AppConfig::DeploymentStrategy"),
    AWS_APP_FLOW_FLOW("AWS::AppFlow::Flow"),
    AWS_AUDIT_MANAGER_ASSESSMENT("AWS::AuditManager::Assessment"),
    AWS_CLOUD_WATCH_METRIC_STREAM("AWS::CloudWatch::MetricStream"),
    AWS_DEVICE_FARM_INSTANCE_PROFILE("AWS::DeviceFarm::InstanceProfile"),
    AWS_DEVICE_FARM_PROJECT("AWS::DeviceFarm::Project"),
    AWS_EC2_EC2_FLEET("AWS::EC2::EC2Fleet"),
    AWS_EC2_SUBNET_ROUTE_TABLE_ASSOCIATION("AWS::EC2::SubnetRouteTableAssociation"),
    AWS_ECR_PULL_THROUGH_CACHE_RULE("AWS::ECR::PullThroughCacheRule"),
    AWS_GROUND_STATION_CONFIG("AWS::GroundStation::Config"),
    AWS_IMAGE_BUILDER_IMAGE_PIPELINE("AWS::ImageBuilder::ImagePipeline"),
    AWS_IOT_FLEET_METRIC("AWS::IoT::FleetMetric"),
    AWS_IO_T_WIRELESS_SERVICE_PROFILE("AWS::IoTWireless::ServiceProfile"),
    AWS_NETWORK_MANAGER_DEVICE("AWS::NetworkManager::Device"),
    AWS_NETWORK_MANAGER_GLOBAL_NETWORK("AWS::NetworkManager::GlobalNetwork"),
    AWS_NETWORK_MANAGER_LINK("AWS::NetworkManager::Link"),
    AWS_NETWORK_MANAGER_SITE("AWS::NetworkManager::Site"),
    AWS_PANORAMA_PACKAGE("AWS::Panorama::Package"),
    AWS_PINPOINT_APP("AWS::Pinpoint::App"),
    AWS_REDSHIFT_SCHEDULED_ACTION("AWS::Redshift::ScheduledAction"),
    AWS_ROUTE53_RESOLVER_FIREWALL_RULE_GROUP_ASSOCIATION("AWS::Route53Resolver::FirewallRuleGroupAssociation"),
    AWS_SAGE_MAKER_APP_IMAGE_CONFIG("AWS::SageMaker::AppImageConfig"),
    AWS_SAGE_MAKER_IMAGE("AWS::SageMaker::Image"),
    AWS_ECS_TASK_SET("AWS::ECS::TaskSet"),
    AWS_CASSANDRA_KEYSPACE("AWS::Cassandra::Keyspace"),
    AWS_SIGNER_SIGNING_PROFILE("AWS::Signer::SigningProfile"),
    AWS_AMPLIFY_APP("AWS::Amplify::App"),
    AWS_APP_MESH_VIRTUAL_NODE("AWS::AppMesh::VirtualNode"),
    AWS_APP_MESH_VIRTUAL_SERVICE("AWS::AppMesh::VirtualService"),
    AWS_APP_RUNNER_VPC_CONNECTOR("AWS::AppRunner::VpcConnector"),
    AWS_APP_STREAM_APPLICATION("AWS::AppStream::Application"),
    AWS_CODE_ARTIFACT_REPOSITORY("AWS::CodeArtifact::Repository"),
    AWS_EC2_PREFIX_LIST("AWS::EC2::PrefixList"),
    AWS_EC2_SPOT_FLEET("AWS::EC2::SpotFleet"),
    AWS_EVIDENTLY_PROJECT("AWS::Evidently::Project"),
    AWS_FORECAST_DATASET("AWS::Forecast::Dataset"),
    AWS_IAM_SAML_PROVIDER("AWS::IAM::SAMLProvider"),
    AWS_IAM_SERVER_CERTIFICATE("AWS::IAM::ServerCertificate"),
    AWS_PINPOINT_CAMPAIGN("AWS::Pinpoint::Campaign"),
    AWS_PINPOINT_IN_APP_TEMPLATE("AWS::Pinpoint::InAppTemplate"),
    AWS_SAGE_MAKER_DOMAIN("AWS::SageMaker::Domain"),
    AWS_TRANSFER_AGREEMENT("AWS::Transfer::Agreement"),
    AWS_TRANSFER_CONNECTOR("AWS::Transfer::Connector"),
    AWS_KINESIS_FIREHOSE_DELIVERY_STREAM("AWS::KinesisFirehose::DeliveryStream"),
    AWS_AMPLIFY_BRANCH("AWS::Amplify::Branch"),
    AWS_APP_INTEGRATIONS_EVENT_INTEGRATION("AWS::AppIntegrations::EventIntegration"),
    AWS_APP_MESH_ROUTE("AWS::AppMesh::Route"),
    AWS_ATHENA_PREPARED_STATEMENT("AWS::Athena::PreparedStatement"),
    AWS_EC2_IPAM_SCOPE("AWS::EC2::IPAMScope"),
    AWS_EVIDENTLY_LAUNCH("AWS::Evidently::Launch"),
    AWS_FORECAST_DATASET_GROUP("AWS::Forecast::DatasetGroup"),
    AWS_GREENGRASS_V2_COMPONENT_VERSION("AWS::GreengrassV2::ComponentVersion"),
    AWS_GROUND_STATION_MISSION_PROFILE("AWS::GroundStation::MissionProfile"),
    AWS_MEDIA_CONNECT_FLOW_ENTITLEMENT("AWS::MediaConnect::FlowEntitlement"),
    AWS_MEDIA_CONNECT_FLOW_VPC_INTERFACE("AWS::MediaConnect::FlowVpcInterface"),
    AWS_MEDIA_TAILOR_PLAYBACK_CONFIGURATION("AWS::MediaTailor::PlaybackConfiguration"),
    AWS_MSK_CONFIGURATION("AWS::MSK::Configuration"),
    AWS_PERSONALIZE_DATASET("AWS::Personalize::Dataset"),
    AWS_PERSONALIZE_SCHEMA("AWS::Personalize::Schema"),
    AWS_PERSONALIZE_SOLUTION("AWS::Personalize::Solution"),
    AWS_PINPOINT_EMAIL_TEMPLATE("AWS::Pinpoint::EmailTemplate"),
    AWS_PINPOINT_EVENT_STREAM("AWS::Pinpoint::EventStream"),
    AWS_RESILIENCE_HUB_APP("AWS::ResilienceHub::App"),
    AWS_ACMPCA_CERTIFICATE_AUTHORITY("AWS::ACMPCA::CertificateAuthority"),
    AWS_APP_CONFIG_HOSTED_CONFIGURATION_VERSION("AWS::AppConfig::HostedConfigurationVersion"),
    AWS_APP_MESH_VIRTUAL_GATEWAY("AWS::AppMesh::VirtualGateway"),
    AWS_APP_MESH_VIRTUAL_ROUTER("AWS::AppMesh::VirtualRouter"),
    AWS_APP_RUNNER_SERVICE("AWS::AppRunner::Service"),
    AWS_CUSTOMER_PROFILES_OBJECT_TYPE("AWS::CustomerProfiles::ObjectType"),
    AWS_DMS_ENDPOINT("AWS::DMS::Endpoint"),
    AWS_EC2_CAPACITY_RESERVATION("AWS::EC2::CapacityReservation"),
    AWS_EC2_CLIENT_VPN_ENDPOINT("AWS::EC2::ClientVpnEndpoint"),
    AWS_KENDRA_INDEX("AWS::Kendra::Index"),
    AWS_KINESIS_VIDEO_STREAM("AWS::KinesisVideo::Stream"),
    AWS_LOGS_DESTINATION("AWS::Logs::Destination"),
    AWS_PINPOINT_EMAIL_CHANNEL("AWS::Pinpoint::EmailChannel"),
    AWS_S3_ACCESS_POINT("AWS::S3::AccessPoint"),
    AWS_NETWORK_MANAGER_CUSTOMER_GATEWAY_ASSOCIATION("AWS::NetworkManager::CustomerGatewayAssociation"),
    AWS_NETWORK_MANAGER_LINK_ASSOCIATION("AWS::NetworkManager::LinkAssociation"),
    AWS_IO_T_WIRELESS_MULTICAST_GROUP("AWS::IoTWireless::MulticastGroup"),
    AWS_PERSONALIZE_DATASET_GROUP("AWS::Personalize::DatasetGroup"),
    AWS_IO_T_TWIN_MAKER_COMPONENT_TYPE("AWS::IoTTwinMaker::ComponentType"),
    AWS_CODE_BUILD_REPORT_GROUP("AWS::CodeBuild::ReportGroup"),
    AWS_SAGE_MAKER_FEATURE_GROUP("AWS::SageMaker::FeatureGroup"),
    AWS_MSK_BATCH_SCRAM_SECRET("AWS::MSK::BatchScramSecret"),
    AWS_APP_STREAM_STACK("AWS::AppStream::Stack"),
    AWS_IOT_JOB_TEMPLATE("AWS::IoT::JobTemplate"),
    AWS_IO_T_WIRELESS_FUOTA_TASK("AWS::IoTWireless::FuotaTask"),
    AWS_IOT_PROVISIONING_TEMPLATE("AWS::IoT::ProvisioningTemplate"),
    AWS_INSPECTOR_V2_FILTER("AWS::InspectorV2::Filter"),
    AWS_ROUTE53_RESOLVER_RESOLVER_QUERY_LOGGING_CONFIG_ASSOCIATION("AWS::Route53Resolver::ResolverQueryLoggingConfigAssociation"),
    AWS_SERVICE_DISCOVERY_INSTANCE("AWS::ServiceDiscovery::Instance"),
    AWS_TRANSFER_CERTIFICATE("AWS::Transfer::Certificate"),
    AWS_MEDIA_CONNECT_FLOW_SOURCE("AWS::MediaConnect::FlowSource"),
    AWS_APS_RULE_GROUPS_NAMESPACE("AWS::APS::RuleGroupsNamespace"),
    AWS_CODE_GURU_PROFILER_PROFILING_GROUP("AWS::CodeGuruProfiler::ProfilingGroup"),
    AWS_ROUTE53_RESOLVER_RESOLVER_QUERY_LOGGING_CONFIG("AWS::Route53Resolver::ResolverQueryLoggingConfig"),
    AWS_BATCH_SCHEDULING_POLICY("AWS::Batch::SchedulingPolicy"),
    AWS_ACMPCA_CERTIFICATE_AUTHORITY_ACTIVATION("AWS::ACMPCA::CertificateAuthorityActivation"),
    AWS_APP_MESH_GATEWAY_ROUTE("AWS::AppMesh::GatewayRoute"),
    AWS_APP_MESH_MESH("AWS::AppMesh::Mesh"),
    AWS_CONNECT_INSTANCE("AWS::Connect::Instance"),
    AWS_CONNECT_QUICK_CONNECT("AWS::Connect::QuickConnect"),
    AWS_EC2_CARRIER_GATEWAY("AWS::EC2::CarrierGateway"),
    AWS_EC2_IPAM_POOL("AWS::EC2::IPAMPool"),
    AWS_EC2_TRANSIT_GATEWAY_CONNECT("AWS::EC2::TransitGatewayConnect"),
    AWS_EC2_TRANSIT_GATEWAY_MULTICAST_DOMAIN("AWS::EC2::TransitGatewayMulticastDomain"),
    AWS_ECS_CAPACITY_PROVIDER("AWS::ECS::CapacityProvider"),
    AWS_IAM_INSTANCE_PROFILE("AWS::IAM::InstanceProfile"),
    AWS_IOT_CA_CERTIFICATE("AWS::IoT::CACertificate"),
    AWS_IO_T_TWIN_MAKER_SYNC_JOB("AWS::IoTTwinMaker::SyncJob"),
    AWS_KAFKA_CONNECT_CONNECTOR("AWS::KafkaConnect::Connector"),
    AWS_LAMBDA_CODE_SIGNING_CONFIG("AWS::Lambda::CodeSigningConfig"),
    AWS_NETWORK_MANAGER_CONNECT_PEER("AWS::NetworkManager::ConnectPeer"),
    AWS_RESOURCE_EXPLORER2_INDEX("AWS::ResourceExplorer2::Index"),
    AWS_APP_STREAM_FLEET("AWS::AppStream::Fleet"),
    AWS_COGNITO_USER_POOL("AWS::Cognito::UserPool"),
    AWS_COGNITO_USER_POOL_CLIENT("AWS::Cognito::UserPoolClient"),
    AWS_COGNITO_USER_POOL_GROUP("AWS::Cognito::UserPoolGroup"),
    AWS_EC2_NETWORK_INSIGHTS_ACCESS_SCOPE("AWS::EC2::NetworkInsightsAccessScope"),
    AWS_EC2_NETWORK_INSIGHTS_ANALYSIS("AWS::EC2::NetworkInsightsAnalysis"),
    AWS_GRAFANA_WORKSPACE("AWS::Grafana::Workspace"),
    AWS_GROUND_STATION_DATAFLOW_ENDPOINT_GROUP("AWS::GroundStation::DataflowEndpointGroup"),
    AWS_IMAGE_BUILDER_IMAGE_RECIPE("AWS::ImageBuilder::ImageRecipe"),
    AWS_KMS_ALIAS("AWS::KMS::Alias"),
    AWS_M2_ENVIRONMENT("AWS::M2::Environment"),
    AWS_QUICK_SIGHT_DATA_SOURCE("AWS::QuickSight::DataSource"),
    AWS_QUICK_SIGHT_TEMPLATE("AWS::QuickSight::Template"),
    AWS_QUICK_SIGHT_THEME("AWS::QuickSight::Theme"),
    AWS_RDS_OPTION_GROUP("AWS::RDS::OptionGroup"),
    AWS_REDSHIFT_ENDPOINT_ACCESS("AWS::Redshift::EndpointAccess"),
    AWS_ROUTE53_RESOLVER_FIREWALL_RULE_GROUP("AWS::Route53Resolver::FirewallRuleGroup"),
    AWS_SSM_DOCUMENT("AWS::SSM::Document"),
    AWS_APP_CONFIG_EXTENSION_ASSOCIATION("AWS::AppConfig::ExtensionAssociation"),
    AWS_APP_INTEGRATIONS_APPLICATION("AWS::AppIntegrations::Application"),
    AWS_APP_SYNC_API_CACHE("AWS::AppSync::ApiCache"),
    AWS_BEDROCK_GUARDRAIL("AWS::Bedrock::Guardrail"),
    AWS_BEDROCK_KNOWLEDGE_BASE("AWS::Bedrock::KnowledgeBase"),
    AWS_COGNITO_IDENTITY_POOL("AWS::Cognito::IdentityPool"),
    AWS_CONNECT_RULE("AWS::Connect::Rule"),
    AWS_CONNECT_USER("AWS::Connect::User"),
    AWS_EC2_CLIENT_VPN_TARGET_NETWORK_ASSOCIATION("AWS::EC2::ClientVpnTargetNetworkAssociation"),
    AWS_EC2_EIP_ASSOCIATION("AWS::EC2::EIPAssociation"),
    AWS_EC2_IPAM_RESOURCE_DISCOVERY("AWS::EC2::IPAMResourceDiscovery"),
    AWS_EC2_IPAM_RESOURCE_DISCOVERY_ASSOCIATION("AWS::EC2::IPAMResourceDiscoveryAssociation"),
    AWS_EC2_INSTANCE_CONNECT_ENDPOINT("AWS::EC2::InstanceConnectEndpoint"),
    AWS_EC2_SNAPSHOT_BLOCK_PUBLIC_ACCESS("AWS::EC2::SnapshotBlockPublicAccess"),
    AWS_EC2_VPC_BLOCK_PUBLIC_ACCESS_EXCLUSION("AWS::EC2::VPCBlockPublicAccessExclusion"),
    AWS_EC2_VPC_BLOCK_PUBLIC_ACCESS_OPTIONS("AWS::EC2::VPCBlockPublicAccessOptions"),
    AWS_EC2_VPC_ENDPOINT_CONNECTION_NOTIFICATION("AWS::EC2::VPCEndpointConnectionNotification"),
    AWS_EC2_VPN_CONNECTION_ROUTE("AWS::EC2::VPNConnectionRoute"),
    AWS_EVIDENTLY_SEGMENT("AWS::Evidently::Segment"),
    AWS_IAM_OIDC_PROVIDER("AWS::IAM::OIDCProvider"),
    AWS_INSPECTOR_V2_ACTIVATION("AWS::InspectorV2::Activation"),
    AWS_MSK_CLUSTER_POLICY("AWS::MSK::ClusterPolicy"),
    AWS_MSK_VPC_CONNECTION("AWS::MSK::VpcConnection"),
    AWS_MEDIA_CONNECT_GATEWAY("AWS::MediaConnect::Gateway"),
    AWS_MEMORY_DB_SUBNET_GROUP("AWS::MemoryDB::SubnetGroup"),
    AWS_OPEN_SEARCH_SERVERLESS_COLLECTION("AWS::OpenSearchServerless::Collection"),
    AWS_OPEN_SEARCH_SERVERLESS_VPC_ENDPOINT("AWS::OpenSearchServerless::VpcEndpoint"),
    AWS_REDSHIFT_ENDPOINT_AUTHORIZATION("AWS::Redshift::EndpointAuthorization"),
    AWS_ROUTE53_PROFILES_PROFILE("AWS::Route53Profiles::Profile"),
    AWS_S3_STORAGE_LENS_GROUP("AWS::S3::StorageLensGroup"),
    AWS_S3_EXPRESS_BUCKET_POLICY("AWS::S3Express::BucketPolicy"),
    AWS_S3_EXPRESS_DIRECTORY_BUCKET("AWS::S3Express::DirectoryBucket"),
    AWS_SAGE_MAKER_INFERENCE_EXPERIMENT("AWS::SageMaker::InferenceExperiment"),
    AWS_SECURITY_HUB_STANDARD("AWS::SecurityHub::Standard"),
    AWS_TRANSFER_PROFILE("AWS::Transfer::Profile"),
    AWS_CLOUD_FORMATION_STACK_SET("AWS::CloudFormation::StackSet"),
    AWS_MEDIA_PACKAGE_V2_CHANNEL("AWS::MediaPackageV2::Channel"),
    AWS_S3_ACCESS_GRANTS_LOCATION("AWS::S3::AccessGrantsLocation"),
    AWS_S3_ACCESS_GRANT("AWS::S3::AccessGrant"),
    AWS_S3_ACCESS_GRANTS_INSTANCE("AWS::S3::AccessGrantsInstance"),
    AWS_EMR_SERVERLESS_APPLICATION("AWS::EMRServerless::Application"),
    AWS_CONFIG_AGGREGATION_AUTHORIZATION("AWS::Config::AggregationAuthorization"),
    AWS_BEDROCK_APPLICATION_INFERENCE_PROFILE("AWS::Bedrock::ApplicationInferenceProfile"),
    AWS_API_GATEWAY_V2_INTEGRATION("AWS::ApiGatewayV2::Integration"),
    AWS_SAGE_MAKER_MLFLOW_TRACKING_SERVER("AWS::SageMaker::MlflowTrackingServer"),
    AWS_SAGE_MAKER_MODEL_BIAS_JOB_DEFINITION("AWS::SageMaker::ModelBiasJobDefinition"),
    AWS_SECRETS_MANAGER_ROTATION_SCHEDULE("AWS::SecretsManager::RotationSchedule"),
    AWS_DEADLINE_QUEUE_FLEET_ASSOCIATION("AWS::Deadline::QueueFleetAssociation"),
    AWS_ECR_REPOSITORY_CREATION_TEMPLATE("AWS::ECR::RepositoryCreationTemplate"),
    AWS_CLOUD_FORMATION_LAMBDA_HOOK("AWS::CloudFormation::LambdaHook"),
    AWS_EC2_SUBNET_NETWORK_ACL_ASSOCIATION("AWS::EC2::SubnetNetworkAclAssociation"),
    AWS_API_GATEWAY_USAGE_PLAN("AWS::ApiGateway::UsagePlan"),
    AWS_APP_CONFIG_EXTENSION("AWS::AppConfig::Extension"),
    AWS_DEADLINE_FLEET("AWS::Deadline::Fleet"),
    AWS_EMR_STUDIO("AWS::EMR::Studio"),
    AWS_S3_TABLES_TABLE_BUCKET("AWS::S3Tables::TableBucket"),
    AWS_CLOUD_FRONT_REALTIME_LOG_CONFIG("AWS::CloudFront::RealtimeLogConfig"),
    AWS_BACKUP_GATEWAY_HYPERVISOR("AWS::BackupGateway::Hypervisor"),
    AWS_BCM_DATA_EXPORTS_EXPORT("AWS::BCMDataExports::Export"),
    AWS_CLOUD_FORMATION_GUARD_HOOK("AWS::CloudFormation::GuardHook"),
    AWS_CLOUD_FRONT_PUBLIC_KEY("AWS::CloudFront::PublicKey"),
    AWS_CLOUD_TRAIL_EVENT_DATA_STORE("AWS::CloudTrail::EventDataStore"),
    AWS_ENTITY_RESOLUTION_ID_MAPPING_WORKFLOW("AWS::EntityResolution::IdMappingWorkflow"),
    AWS_ENTITY_RESOLUTION_SCHEMA_MAPPING("AWS::EntityResolution::SchemaMapping"),
    AWS_IOT_DOMAIN_CONFIGURATION("AWS::IoT::DomainConfiguration"),
    AWS_PCA_CONNECTOR_AD_DIRECTORY_REGISTRATION("AWS::PCAConnectorAD::DirectoryRegistration"),
    AWS_RDS_INTEGRATION("AWS::RDS::Integration"),
    AWS_CONFIG_CONFORMANCE_PACK("AWS::Config::ConformancePack"),
    AWS_ROLES_ANYWHERE_PROFILE("AWS::RolesAnywhere::Profile"),
    AWS_CODE_ARTIFACT_DOMAIN("AWS::CodeArtifact::Domain"),
    AWS_BACKUP_RESTORE_TESTING_PLAN("AWS::Backup::RestoreTestingPlan"),
    AWS_CONFIG_STORED_QUERY("AWS::Config::StoredQuery"),
    AWS_SAGE_MAKER_DATA_QUALITY_JOB_DEFINITION("AWS::SageMaker::DataQualityJobDefinition"),
    AWS_SAGE_MAKER_MODEL_EXPLAINABILITY_JOB_DEFINITION("AWS::SageMaker::ModelExplainabilityJobDefinition"),
    AWS_SAGE_MAKER_MODEL_QUALITY_JOB_DEFINITION("AWS::SageMaker::ModelQualityJobDefinition"),
    AWS_SAGE_MAKER_STUDIO_LIFECYCLE_CONFIG("AWS::SageMaker::StudioLifecycleConfig"),
    AWS_SES_DEDICATED_IP_POOL("AWS::SES::DedicatedIpPool"),
    AWS_SES_MAIL_MANAGER_TRAFFIC_POLICY("AWS::SES::MailManagerTrafficPolicy"),
    AWS_SSM_RESOURCE_DATA_SYNC("AWS::SSM::ResourceDataSync"),
    AWS_BEDROCK_AGENT_CORE_RUNTIME("AWS::BedrockAgentCore::Runtime"),
    AWS_BEDROCK_AGENT_CORE_BROWSER_CUSTOM("AWS::BedrockAgentCore::BrowserCustom"),
    AWS_ELASTIC_LOAD_BALANCING_V2_TARGET_GROUP("AWS::ElasticLoadBalancingV2::TargetGroup"),
    AWS_EMR_CONTAINERS_VIRTUAL_CLUSTER("AWS::EMRContainers::VirtualCluster"),
    AWS_ENTITY_RESOLUTION_MATCHING_WORKFLOW("AWS::EntityResolution::MatchingWorkflow"),
    AWS_IO_T_CORE_DEVICE_ADVISOR_SUITE_DEFINITION("AWS::IoTCoreDeviceAdvisor::SuiteDefinition"),
    AWS_EC2_SECURITY_GROUP_VPC_ASSOCIATION("AWS::EC2::SecurityGroupVpcAssociation"),
    AWS_EC2_VERIFIED_ACCESS_INSTANCE("AWS::EC2::VerifiedAccessInstance"),
    AWS_KAFKA_CONNECT_CUSTOM_PLUGIN("AWS::KafkaConnect::CustomPlugin"),
    AWS_NETWORK_MANAGER_TRANSIT_GATEWAY_PEERING("AWS::NetworkManager::TransitGatewayPeering"),
    AWS_OPEN_SEARCH_SERVERLESS_SECURITY_CONFIG("AWS::OpenSearchServerless::SecurityConfig"),
    AWS_REDSHIFT_INTEGRATION("AWS::Redshift::Integration"),
    AWS_ROLES_ANYWHERE_TRUST_ANCHOR("AWS::RolesAnywhere::TrustAnchor"),
    AWS_ROUTE53_PROFILES_PROFILE_ASSOCIATION("AWS::Route53Profiles::ProfileAssociation"),
    AWS_SSM_INCIDENTS_RESPONSE_PLAN("AWS::SSMIncidents::ResponsePlan"),
    AWS_TRANSFER_SERVER("AWS::Transfer::Server"),
    AWS_GLUE_DATABASE("AWS::Glue::Database"),
    AWS_ORGANIZATIONS_ORGANIZATIONAL_UNIT("AWS::Organizations::OrganizationalUnit"),
    AWS_EC2_IPAM_POOL_CIDR("AWS::EC2::IPAMPoolCidr"),
    AWS_EC2_VPC_GATEWAY_ATTACHMENT("AWS::EC2::VPCGatewayAttachment"),
    AWS_BEDROCK_PROMPT("AWS::Bedrock::Prompt"),
    AWS_COMPREHEND_FLYWHEEL("AWS::Comprehend::Flywheel"),
    AWS_DATA_SYNC_AGENT("AWS::DataSync::Agent"),
    AWS_MEDIA_TAILOR_LIVE_SOURCE("AWS::MediaTailor::LiveSource"),
    AWS_MSK_SERVERLESS_CLUSTER("AWS::MSK::ServerlessCluster"),
    AWS_IO_T_SITE_WISE_ASSET("AWS::IoTSiteWise::Asset"),
    AWS_B2_BI_CAPABILITY("AWS::B2BI::Capability"),
    AWS_CLOUD_FRONT_KEY_VALUE_STORE("AWS::CloudFront::KeyValueStore"),
    AWS_DEADLINE_MONITOR("AWS::Deadline::Monitor"),
    AWS_GUARD_DUTY_MALWARE_PROTECTION_PLAN("AWS::GuardDuty::MalwareProtectionPlan"),
    AWS_LOCATION_API_KEY("AWS::Location::APIKey"),
    AWS_MEDIA_PACKAGE_V2_ORIGIN_ENDPOINT("AWS::MediaPackageV2::OriginEndpoint"),
    AWS_PCA_CONNECTOR_AD_CONNECTOR("AWS::PCAConnectorAD::Connector"),
    AWS_S3_TABLES_TABLE_BUCKET_POLICY("AWS::S3Tables::TableBucketPolicy"),
    AWS_SECRETS_MANAGER_RESOURCE_POLICY("AWS::SecretsManager::ResourcePolicy"),
    AWS_SSM_CONTACTS_CONTACT("AWS::SSMContacts::Contact"),
    AWS_IOT_THING_GROUP("AWS::IoT::ThingGroup"),
    AWS_IMAGE_BUILDER_LIFECYCLE_POLICY("AWS::ImageBuilder::LifecyclePolicy"),
    AWS_GAME_LIFT_BUILD("AWS::GameLift::Build"),
    AWS_ECR_REPLICATION_CONFIGURATION("AWS::ECR::ReplicationConfiguration"),
    AWS_EC2_SUBNET_CIDR_BLOCK("AWS::EC2::SubnetCidrBlock"),
    AWS_CONNECT_SECURITY_PROFILE("AWS::Connect::SecurityProfile"),
    AWS_CLEAN_ROOMS_ML_TRAINING_DATASET("AWS::CleanRoomsML::TrainingDataset"),
    AWS_APP_STREAM_APP_BLOCK_BUILDER("AWS::AppStream::AppBlockBuilder"),
    AWS_ROUTE53_DNSSEC("AWS::Route53::DNSSEC"),
    AWS_SAGE_MAKER_USER_PROFILE("AWS::SageMaker::UserProfile"),
    AWS_API_GATEWAY_METHOD("AWS::ApiGateway::Method"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

