/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRule;

public class DescribeOrganizationConfigRulesPublisher
implements SdkPublisher<DescribeOrganizationConfigRulesResponse> {
    private final ConfigAsyncClient client;
    private final DescribeOrganizationConfigRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrganizationConfigRulesPublisher(ConfigAsyncClient client, DescribeOrganizationConfigRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrganizationConfigRulesPublisher(ConfigAsyncClient client, DescribeOrganizationConfigRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrganizationConfigRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrganizationConfigRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationConfigRule> organizationConfigRules() {
        return this.flatMapIterable(response -> response.organizationConfigRules());
    }

    private class DescribeOrganizationConfigRulesResponseFetcher
    implements AsyncPageFetcher<DescribeOrganizationConfigRulesResponse> {
        private DescribeOrganizationConfigRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConfigRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOrganizationConfigRulesResponse> nextPage(DescribeOrganizationConfigRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConfigRulesPublisher.this.client.describeOrganizationConfigRules(DescribeOrganizationConfigRulesPublisher.this.firstRequest);
            }
            return DescribeOrganizationConfigRulesPublisher.this.client.describeOrganizationConfigRules((DescribeOrganizationConfigRulesRequest)((Object)DescribeOrganizationConfigRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

