/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ConfigRuleEvaluationStatus;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;

public class DescribeConfigRuleEvaluationStatusPublisher
implements SdkPublisher<DescribeConfigRuleEvaluationStatusResponse> {
    private final ConfigAsyncClient client;
    private final DescribeConfigRuleEvaluationStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConfigRuleEvaluationStatusPublisher(ConfigAsyncClient client, DescribeConfigRuleEvaluationStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConfigRuleEvaluationStatusPublisher(ConfigAsyncClient client, DescribeConfigRuleEvaluationStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConfigRuleEvaluationStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConfigRuleEvaluationStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigRuleEvaluationStatus> configRulesEvaluationStatus() {
        return this.flatMapIterable(response -> response.configRulesEvaluationStatus());
    }

    private class DescribeConfigRuleEvaluationStatusResponseFetcher
    implements AsyncPageFetcher<DescribeConfigRuleEvaluationStatusResponse> {
        private DescribeConfigRuleEvaluationStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConfigRuleEvaluationStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> nextPage(DescribeConfigRuleEvaluationStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeConfigRuleEvaluationStatusPublisher.this.client.describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusPublisher.this.firstRequest);
            }
            return DescribeConfigRuleEvaluationStatusPublisher.this.client.describeConfigRuleEvaluationStatus((DescribeConfigRuleEvaluationStatusRequest)((Object)DescribeConfigRuleEvaluationStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

