/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StoredQueryMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StoredQueryMetadata> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(StoredQueryMetadata.getter(StoredQueryMetadata::queryId)).setter(StoredQueryMetadata.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<String> QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryArn").getter(StoredQueryMetadata.getter(StoredQueryMetadata::queryArn)).setter(StoredQueryMetadata.setter(Builder::queryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArn").build()}).build();
    private static final SdkField<String> QUERY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryName").getter(StoredQueryMetadata.getter(StoredQueryMetadata::queryName)).setter(StoredQueryMetadata.setter(Builder::queryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StoredQueryMetadata.getter(StoredQueryMetadata::description)).setter(StoredQueryMetadata.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, QUERY_ARN_FIELD, QUERY_NAME_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StoredQueryMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String queryId;
    private final String queryArn;
    private final String queryName;
    private final String description;

    private StoredQueryMetadata(BuilderImpl builder) {
        this.queryId = builder.queryId;
        this.queryArn = builder.queryArn;
        this.queryName = builder.queryName;
        this.description = builder.description;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final String queryArn() {
        return this.queryArn;
    }

    public final String queryName() {
        return this.queryName;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoredQueryMetadata)) {
            return false;
        }
        StoredQueryMetadata other = (StoredQueryMetadata)obj;
        return Objects.equals(this.queryId(), other.queryId()) && Objects.equals(this.queryArn(), other.queryArn()) && Objects.equals(this.queryName(), other.queryName()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"StoredQueryMetadata").add("QueryId", (Object)this.queryId()).add("QueryArn", (Object)this.queryArn()).add("QueryName", (Object)this.queryName()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "QueryArn": {
                return Optional.ofNullable(clazz.cast(this.queryArn()));
            }
            case "QueryName": {
                return Optional.ofNullable(clazz.cast(this.queryName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("QueryArn", QUERY_ARN_FIELD);
        map.put("QueryName", QUERY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StoredQueryMetadata, T> g) {
        return obj -> g.apply((StoredQueryMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String queryId;
        private String queryArn;
        private String queryName;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StoredQueryMetadata model) {
            this.queryId(model.queryId);
            this.queryArn(model.queryArn);
            this.queryName(model.queryName);
            this.description(model.description);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryArn() {
            return this.queryArn;
        }

        public final void setQueryArn(String queryArn) {
            this.queryArn = queryArn;
        }

        @Override
        public final Builder queryArn(String queryArn) {
            this.queryArn = queryArn;
            return this;
        }

        public final String getQueryName() {
            return this.queryName;
        }

        public final void setQueryName(String queryName) {
            this.queryName = queryName;
        }

        @Override
        public final Builder queryName(String queryName) {
            this.queryName = queryName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public StoredQueryMetadata build() {
            return new StoredQueryMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StoredQueryMetadata> {
        public Builder queryId(String var1);

        public Builder queryArn(String var1);

        public Builder queryName(String var1);

        public Builder description(String var1);
    }
}

