/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.RemediationConfiguration;
import software.amazon.awssdk.services.config.model.RemediationConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRemediationConfigurationsResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeRemediationConfigurationsResponse> {
    private static final SdkField<List<RemediationConfiguration>> REMEDIATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemediationConfigurations").getter(DescribeRemediationConfigurationsResponse.getter(DescribeRemediationConfigurationsResponse::remediationConfigurations)).setter(DescribeRemediationConfigurationsResponse.setter(Builder::remediationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RemediationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REMEDIATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRemediationConfigurationsResponse.memberNameToFieldInitializer();
    private final List<RemediationConfiguration> remediationConfigurations;

    private DescribeRemediationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.remediationConfigurations = builder.remediationConfigurations;
    }

    public final boolean hasRemediationConfigurations() {
        return this.remediationConfigurations != null && !(this.remediationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RemediationConfiguration> remediationConfigurations() {
        return this.remediationConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemediationConfigurations() ? this.remediationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRemediationConfigurationsResponse)) {
            return false;
        }
        DescribeRemediationConfigurationsResponse other = (DescribeRemediationConfigurationsResponse)((Object)obj);
        return this.hasRemediationConfigurations() == other.hasRemediationConfigurations() && Objects.equals(this.remediationConfigurations(), other.remediationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRemediationConfigurationsResponse").add("RemediationConfigurations", this.hasRemediationConfigurations() ? this.remediationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RemediationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.remediationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RemediationConfiguration>>> map = new HashMap<String, SdkField<List<RemediationConfiguration>>>();
        map.put("RemediationConfigurations", REMEDIATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRemediationConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeRemediationConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<RemediationConfiguration> remediationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRemediationConfigurationsResponse model) {
            super(model);
            this.remediationConfigurations(model.remediationConfigurations);
        }

        public final List<RemediationConfiguration.Builder> getRemediationConfigurations() {
            List<RemediationConfiguration.Builder> result = RemediationConfigurationsCopier.copyToBuilder(this.remediationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemediationConfigurations(Collection<RemediationConfiguration.BuilderImpl> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copyFromBuilder(remediationConfigurations);
        }

        @Override
        public final Builder remediationConfigurations(Collection<RemediationConfiguration> remediationConfigurations) {
            this.remediationConfigurations = RemediationConfigurationsCopier.copy(remediationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationConfigurations(RemediationConfiguration ... remediationConfigurations) {
            this.remediationConfigurations(Arrays.asList(remediationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder> ... remediationConfigurations) {
            this.remediationConfigurations(Stream.of(remediationConfigurations).map(c -> (RemediationConfiguration)((RemediationConfiguration.Builder)RemediationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeRemediationConfigurationsResponse build() {
            return new DescribeRemediationConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRemediationConfigurationsResponse> {
        public Builder remediationConfigurations(Collection<RemediationConfiguration> var1);

        public Builder remediationConfigurations(RemediationConfiguration ... var1);

        public Builder remediationConfigurations(Consumer<RemediationConfiguration.Builder> ... var1);
    }
}

