/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.config.model.ConfigResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrganizationConfigRuleStatusesResponse
extends ConfigResponse
implements ToCopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesResponse> {
    private static final SdkField<List<OrganizationConfigRuleStatus>> ORGANIZATION_CONFIG_RULE_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationConfigRuleStatuses").getter(DescribeOrganizationConfigRuleStatusesResponse.getter(DescribeOrganizationConfigRuleStatusesResponse::organizationConfigRuleStatuses)).setter(DescribeOrganizationConfigRuleStatusesResponse.setter(Builder::organizationConfigRuleStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationConfigRuleStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationConfigRuleStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeOrganizationConfigRuleStatusesResponse.getter(DescribeOrganizationConfigRuleStatusesResponse::nextToken)).setter(DescribeOrganizationConfigRuleStatusesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_CONFIG_RULE_STATUSES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOrganizationConfigRuleStatusesResponse.memberNameToFieldInitializer();
    private final List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses;
    private final String nextToken;

    private DescribeOrganizationConfigRuleStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.organizationConfigRuleStatuses = builder.organizationConfigRuleStatuses;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrganizationConfigRuleStatuses() {
        return this.organizationConfigRuleStatuses != null && !(this.organizationConfigRuleStatuses instanceof SdkAutoConstructList);
    }

    public final List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses() {
        return this.organizationConfigRuleStatuses;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationConfigRuleStatuses() ? this.organizationConfigRuleStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationConfigRuleStatusesResponse)) {
            return false;
        }
        DescribeOrganizationConfigRuleStatusesResponse other = (DescribeOrganizationConfigRuleStatusesResponse)((Object)obj);
        return this.hasOrganizationConfigRuleStatuses() == other.hasOrganizationConfigRuleStatuses() && Objects.equals(this.organizationConfigRuleStatuses(), other.organizationConfigRuleStatuses()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrganizationConfigRuleStatusesResponse").add("OrganizationConfigRuleStatuses", this.hasOrganizationConfigRuleStatuses() ? this.organizationConfigRuleStatuses() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationConfigRuleStatuses": {
                return Optional.ofNullable(clazz.cast(this.organizationConfigRuleStatuses()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrganizationConfigRuleStatuses", ORGANIZATION_CONFIG_RULE_STATUSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationConfigRuleStatusesResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationConfigRuleStatusesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConfigResponse.BuilderImpl
    implements Builder {
        private List<OrganizationConfigRuleStatus> organizationConfigRuleStatuses = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationConfigRuleStatusesResponse model) {
            super(model);
            this.organizationConfigRuleStatuses(model.organizationConfigRuleStatuses);
            this.nextToken(model.nextToken);
        }

        public final List<OrganizationConfigRuleStatus.Builder> getOrganizationConfigRuleStatuses() {
            List<OrganizationConfigRuleStatus.Builder> result = OrganizationConfigRuleStatusesCopier.copyToBuilder(this.organizationConfigRuleStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrganizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus.BuilderImpl> organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses = OrganizationConfigRuleStatusesCopier.copyFromBuilder(organizationConfigRuleStatuses);
        }

        @Override
        public final Builder organizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus> organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses = OrganizationConfigRuleStatusesCopier.copy(organizationConfigRuleStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleStatuses(OrganizationConfigRuleStatus ... organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses(Arrays.asList(organizationConfigRuleStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationConfigRuleStatuses(Consumer<OrganizationConfigRuleStatus.Builder> ... organizationConfigRuleStatuses) {
            this.organizationConfigRuleStatuses(Stream.of(organizationConfigRuleStatuses).map(c -> (OrganizationConfigRuleStatus)((OrganizationConfigRuleStatus.Builder)OrganizationConfigRuleStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeOrganizationConfigRuleStatusesResponse build() {
            return new DescribeOrganizationConfigRuleStatusesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrganizationConfigRuleStatusesResponse> {
        public Builder organizationConfigRuleStatuses(Collection<OrganizationConfigRuleStatus> var1);

        public Builder organizationConfigRuleStatuses(OrganizationConfigRuleStatus ... var1);

        public Builder organizationConfigRuleStatuses(Consumer<OrganizationConfigRuleStatus.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

