/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ComplianceByResource;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;

public class DescribeComplianceByResourceIterable
implements SdkIterable<DescribeComplianceByResourceResponse> {
    private final ConfigClient client;
    private final DescribeComplianceByResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeComplianceByResourceIterable(ConfigClient client, DescribeComplianceByResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeComplianceByResourceResponseFetcher();
    }

    public Iterator<DescribeComplianceByResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComplianceByResource> complianceByResources() {
        Function<DescribeComplianceByResourceResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceByResources() != null) {
                return response.complianceByResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeComplianceByResourceResponseFetcher
    implements SyncPageFetcher<DescribeComplianceByResourceResponse> {
        private DescribeComplianceByResourceResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComplianceByResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeComplianceByResourceResponse nextPage(DescribeComplianceByResourceResponse previousPage) {
            if (previousPage == null) {
                return DescribeComplianceByResourceIterable.this.client.describeComplianceByResource(DescribeComplianceByResourceIterable.this.firstRequest);
            }
            return DescribeComplianceByResourceIterable.this.client.describeComplianceByResource((DescribeComplianceByResourceRequest)((Object)DescribeComplianceByResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

