/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.config.model.ConformancePackComplianceType;
import software.amazon.awssdk.services.config.model.EvaluationResultIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConformancePackEvaluationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConformancePackEvaluationResult> {
    private static final SdkField<String> COMPLIANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComplianceType").getter(ConformancePackEvaluationResult.getter(ConformancePackEvaluationResult::complianceTypeAsString)).setter(ConformancePackEvaluationResult.setter(Builder::complianceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceType").build()}).build();
    private static final SdkField<EvaluationResultIdentifier> EVALUATION_RESULT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EvaluationResultIdentifier").getter(ConformancePackEvaluationResult.getter(ConformancePackEvaluationResult::evaluationResultIdentifier)).setter(ConformancePackEvaluationResult.setter(Builder::evaluationResultIdentifier)).constructor(EvaluationResultIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationResultIdentifier").build()}).build();
    private static final SdkField<Instant> CONFIG_RULE_INVOKED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConfigRuleInvokedTime").getter(ConformancePackEvaluationResult.getter(ConformancePackEvaluationResult::configRuleInvokedTime)).setter(ConformancePackEvaluationResult.setter(Builder::configRuleInvokedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleInvokedTime").build()}).build();
    private static final SdkField<Instant> RESULT_RECORDED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResultRecordedTime").getter(ConformancePackEvaluationResult.getter(ConformancePackEvaluationResult::resultRecordedTime)).setter(ConformancePackEvaluationResult.setter(Builder::resultRecordedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRecordedTime").build()}).build();
    private static final SdkField<String> ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Annotation").getter(ConformancePackEvaluationResult.getter(ConformancePackEvaluationResult::annotation)).setter(ConformancePackEvaluationResult.setter(Builder::annotation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_TYPE_FIELD, EVALUATION_RESULT_IDENTIFIER_FIELD, CONFIG_RULE_INVOKED_TIME_FIELD, RESULT_RECORDED_TIME_FIELD, ANNOTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConformancePackEvaluationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String complianceType;
    private final EvaluationResultIdentifier evaluationResultIdentifier;
    private final Instant configRuleInvokedTime;
    private final Instant resultRecordedTime;
    private final String annotation;

    private ConformancePackEvaluationResult(BuilderImpl builder) {
        this.complianceType = builder.complianceType;
        this.evaluationResultIdentifier = builder.evaluationResultIdentifier;
        this.configRuleInvokedTime = builder.configRuleInvokedTime;
        this.resultRecordedTime = builder.resultRecordedTime;
        this.annotation = builder.annotation;
    }

    public final ConformancePackComplianceType complianceType() {
        return ConformancePackComplianceType.fromValue(this.complianceType);
    }

    public final String complianceTypeAsString() {
        return this.complianceType;
    }

    public final EvaluationResultIdentifier evaluationResultIdentifier() {
        return this.evaluationResultIdentifier;
    }

    public final Instant configRuleInvokedTime() {
        return this.configRuleInvokedTime;
    }

    public final Instant resultRecordedTime() {
        return this.resultRecordedTime;
    }

    public final String annotation() {
        return this.annotation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResultIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configRuleInvokedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultRecordedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConformancePackEvaluationResult)) {
            return false;
        }
        ConformancePackEvaluationResult other = (ConformancePackEvaluationResult)obj;
        return Objects.equals(this.complianceTypeAsString(), other.complianceTypeAsString()) && Objects.equals(this.evaluationResultIdentifier(), other.evaluationResultIdentifier()) && Objects.equals(this.configRuleInvokedTime(), other.configRuleInvokedTime()) && Objects.equals(this.resultRecordedTime(), other.resultRecordedTime()) && Objects.equals(this.annotation(), other.annotation());
    }

    public final String toString() {
        return ToString.builder((String)"ConformancePackEvaluationResult").add("ComplianceType", (Object)this.complianceTypeAsString()).add("EvaluationResultIdentifier", (Object)this.evaluationResultIdentifier()).add("ConfigRuleInvokedTime", (Object)this.configRuleInvokedTime()).add("ResultRecordedTime", (Object)this.resultRecordedTime()).add("Annotation", (Object)this.annotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComplianceType": {
                return Optional.ofNullable(clazz.cast(this.complianceTypeAsString()));
            }
            case "EvaluationResultIdentifier": {
                return Optional.ofNullable(clazz.cast(this.evaluationResultIdentifier()));
            }
            case "ConfigRuleInvokedTime": {
                return Optional.ofNullable(clazz.cast(this.configRuleInvokedTime()));
            }
            case "ResultRecordedTime": {
                return Optional.ofNullable(clazz.cast(this.resultRecordedTime()));
            }
            case "Annotation": {
                return Optional.ofNullable(clazz.cast(this.annotation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ComplianceType", COMPLIANCE_TYPE_FIELD);
        map.put("EvaluationResultIdentifier", EVALUATION_RESULT_IDENTIFIER_FIELD);
        map.put("ConfigRuleInvokedTime", CONFIG_RULE_INVOKED_TIME_FIELD);
        map.put("ResultRecordedTime", RESULT_RECORDED_TIME_FIELD);
        map.put("Annotation", ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConformancePackEvaluationResult, T> g) {
        return obj -> g.apply((ConformancePackEvaluationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String complianceType;
        private EvaluationResultIdentifier evaluationResultIdentifier;
        private Instant configRuleInvokedTime;
        private Instant resultRecordedTime;
        private String annotation;

        private BuilderImpl() {
        }

        private BuilderImpl(ConformancePackEvaluationResult model) {
            this.complianceType(model.complianceType);
            this.evaluationResultIdentifier(model.evaluationResultIdentifier);
            this.configRuleInvokedTime(model.configRuleInvokedTime);
            this.resultRecordedTime(model.resultRecordedTime);
            this.annotation(model.annotation);
        }

        public final String getComplianceType() {
            return this.complianceType;
        }

        public final void setComplianceType(String complianceType) {
            this.complianceType = complianceType;
        }

        @Override
        public final Builder complianceType(String complianceType) {
            this.complianceType = complianceType;
            return this;
        }

        @Override
        public final Builder complianceType(ConformancePackComplianceType complianceType) {
            this.complianceType(complianceType == null ? null : complianceType.toString());
            return this;
        }

        public final EvaluationResultIdentifier.Builder getEvaluationResultIdentifier() {
            return this.evaluationResultIdentifier != null ? this.evaluationResultIdentifier.toBuilder() : null;
        }

        public final void setEvaluationResultIdentifier(EvaluationResultIdentifier.BuilderImpl evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier != null ? evaluationResultIdentifier.build() : null;
        }

        @Override
        public final Builder evaluationResultIdentifier(EvaluationResultIdentifier evaluationResultIdentifier) {
            this.evaluationResultIdentifier = evaluationResultIdentifier;
            return this;
        }

        public final Instant getConfigRuleInvokedTime() {
            return this.configRuleInvokedTime;
        }

        public final void setConfigRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
        }

        @Override
        public final Builder configRuleInvokedTime(Instant configRuleInvokedTime) {
            this.configRuleInvokedTime = configRuleInvokedTime;
            return this;
        }

        public final Instant getResultRecordedTime() {
            return this.resultRecordedTime;
        }

        public final void setResultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
        }

        @Override
        public final Builder resultRecordedTime(Instant resultRecordedTime) {
            this.resultRecordedTime = resultRecordedTime;
            return this;
        }

        public final String getAnnotation() {
            return this.annotation;
        }

        public final void setAnnotation(String annotation) {
            this.annotation = annotation;
        }

        @Override
        public final Builder annotation(String annotation) {
            this.annotation = annotation;
            return this;
        }

        public ConformancePackEvaluationResult build() {
            return new ConformancePackEvaluationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConformancePackEvaluationResult> {
        public Builder complianceType(String var1);

        public Builder complianceType(ConformancePackComplianceType var1);

        public Builder evaluationResultIdentifier(EvaluationResultIdentifier var1);

        default public Builder evaluationResultIdentifier(Consumer<EvaluationResultIdentifier.Builder> evaluationResultIdentifier) {
            return this.evaluationResultIdentifier((EvaluationResultIdentifier)((EvaluationResultIdentifier.Builder)EvaluationResultIdentifier.builder().applyMutation(evaluationResultIdentifier)).build());
        }

        public Builder configRuleInvokedTime(Instant var1);

        public Builder resultRecordedTime(Instant var1);

        public Builder annotation(String var1);
    }
}

