/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies an Config rule that evaluated an Amazon Web Services resource, and provides the type and ID of the
 * resource that the rule evaluated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationResultQualifier implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationResultQualifier.Builder, EvaluationResultQualifier> {
    private static final SdkField<String> CONFIG_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigRuleName").getter(getter(EvaluationResultQualifier::configRuleName))
            .setter(setter(Builder::configRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigRuleName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(EvaluationResultQualifier::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(EvaluationResultQualifier::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> EVALUATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationMode").getter(getter(EvaluationResultQualifier::evaluationModeAsString))
            .setter(setter(Builder::evaluationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_RULE_NAME_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, EVALUATION_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String configRuleName;

    private final String resourceType;

    private final String resourceId;

    private final String evaluationMode;

    private EvaluationResultQualifier(BuilderImpl builder) {
        this.configRuleName = builder.configRuleName;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.evaluationMode = builder.evaluationMode;
    }

    /**
     * <p>
     * The name of the Config rule that was used in the evaluation.
     * </p>
     * 
     * @return The name of the Config rule that was used in the evaluation.
     */
    public final String configRuleName() {
        return configRuleName;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource that was evaluated.
     * </p>
     * 
     * @return The type of Amazon Web Services resource that was evaluated.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The ID of the evaluated Amazon Web Services resource.
     * </p>
     * 
     * @return The ID of the evaluated Amazon Web Services resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The mode of an evaluation. The valid values are Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final EvaluationMode evaluationMode() {
        return EvaluationMode.fromValue(evaluationMode);
    }

    /**
     * <p>
     * The mode of an evaluation. The valid values are Detective or Proactive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationMode}
     * will return {@link EvaluationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationModeAsString}.
     * </p>
     * 
     * @return The mode of an evaluation. The valid values are Detective or Proactive.
     * @see EvaluationMode
     */
    public final String evaluationModeAsString() {
        return evaluationMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResultQualifier)) {
            return false;
        }
        EvaluationResultQualifier other = (EvaluationResultQualifier) obj;
        return Objects.equals(configRuleName(), other.configRuleName()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(evaluationModeAsString(), other.evaluationModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationResultQualifier").add("ConfigRuleName", configRuleName())
                .add("ResourceType", resourceType()).add("ResourceId", resourceId())
                .add("EvaluationMode", evaluationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigRuleName":
            return Optional.ofNullable(clazz.cast(configRuleName()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "EvaluationMode":
            return Optional.ofNullable(clazz.cast(evaluationModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationResultQualifier, T> g) {
        return obj -> g.apply((EvaluationResultQualifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationResultQualifier> {
        /**
         * <p>
         * The name of the Config rule that was used in the evaluation.
         * </p>
         * 
         * @param configRuleName
         *        The name of the Config rule that was used in the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRuleName(String configRuleName);

        /**
         * <p>
         * The type of Amazon Web Services resource that was evaluated.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource that was evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The ID of the evaluated Amazon Web Services resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the evaluated Amazon Web Services resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The mode of an evaluation. The valid values are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(String evaluationMode);

        /**
         * <p>
         * The mode of an evaluation. The valid values are Detective or Proactive.
         * </p>
         * 
         * @param evaluationMode
         *        The mode of an evaluation. The valid values are Detective or Proactive.
         * @see EvaluationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationMode
         */
        Builder evaluationMode(EvaluationMode evaluationMode);
    }

    static final class BuilderImpl implements Builder {
        private String configRuleName;

        private String resourceType;

        private String resourceId;

        private String evaluationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationResultQualifier model) {
            configRuleName(model.configRuleName);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            evaluationMode(model.evaluationMode);
        }

        public final String getConfigRuleName() {
            return configRuleName;
        }

        public final void setConfigRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
        }

        @Override
        public final Builder configRuleName(String configRuleName) {
            this.configRuleName = configRuleName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getEvaluationMode() {
            return evaluationMode;
        }

        public final void setEvaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
        }

        @Override
        public final Builder evaluationMode(String evaluationMode) {
            this.evaluationMode = evaluationMode;
            return this;
        }

        @Override
        public final Builder evaluationMode(EvaluationMode evaluationMode) {
            this.evaluationMode(evaluationMode == null ? null : evaluationMode.toString());
            return this;
        }

        @Override
        public EvaluationResultQualifier build() {
            return new EvaluationResultQualifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
