/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.AggregateEvaluationResult;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;

public class GetAggregateComplianceDetailsByConfigRuleIterable
implements SdkIterable<GetAggregateComplianceDetailsByConfigRuleResponse> {
    private final ConfigClient client;
    private final GetAggregateComplianceDetailsByConfigRuleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAggregateComplianceDetailsByConfigRuleIterable(ConfigClient client, GetAggregateComplianceDetailsByConfigRuleRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetAggregateComplianceDetailsByConfigRuleResponseFetcher();
    }

    public Iterator<GetAggregateComplianceDetailsByConfigRuleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregateEvaluationResult> aggregateEvaluationResults() {
        Function<GetAggregateComplianceDetailsByConfigRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregateEvaluationResults() != null) {
                return response.aggregateEvaluationResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAggregateComplianceDetailsByConfigRuleResponseFetcher
    implements SyncPageFetcher<GetAggregateComplianceDetailsByConfigRuleResponse> {
        private GetAggregateComplianceDetailsByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(GetAggregateComplianceDetailsByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAggregateComplianceDetailsByConfigRuleResponse nextPage(GetAggregateComplianceDetailsByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return GetAggregateComplianceDetailsByConfigRuleIterable.this.client.getAggregateComplianceDetailsByConfigRule(GetAggregateComplianceDetailsByConfigRuleIterable.this.firstRequest);
            }
            return GetAggregateComplianceDetailsByConfigRuleIterable.this.client.getAggregateComplianceDetailsByConfigRule((GetAggregateComplianceDetailsByConfigRuleRequest)((Object)GetAggregateComplianceDetailsByConfigRuleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

