/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.RemediationExecutionStatus;

public class DescribeRemediationExecutionStatusPublisher
implements SdkPublisher<DescribeRemediationExecutionStatusResponse> {
    private final ConfigAsyncClient client;
    private final DescribeRemediationExecutionStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRemediationExecutionStatusPublisher(ConfigAsyncClient client, DescribeRemediationExecutionStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRemediationExecutionStatusPublisher(ConfigAsyncClient client, DescribeRemediationExecutionStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRemediationExecutionStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRemediationExecutionStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RemediationExecutionStatus> remediationExecutionStatuses() {
        Function<DescribeRemediationExecutionStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.remediationExecutionStatuses() != null) {
                return response.remediationExecutionStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeRemediationExecutionStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeRemediationExecutionStatusResponseFetcher
    implements AsyncPageFetcher<DescribeRemediationExecutionStatusResponse> {
        private DescribeRemediationExecutionStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRemediationExecutionStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeRemediationExecutionStatusResponse> nextPage(DescribeRemediationExecutionStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeRemediationExecutionStatusPublisher.this.client.describeRemediationExecutionStatus(DescribeRemediationExecutionStatusPublisher.this.firstRequest);
            }
            return DescribeRemediationExecutionStatusPublisher.this.client.describeRemediationExecutionStatus((DescribeRemediationExecutionStatusRequest)((Object)DescribeRemediationExecutionStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

