/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResultSummariesCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.PreviewResultSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationRulePreviewSummariesResponse
extends ComputeOptimizerAutomationResponse
implements ToCopyableBuilder<Builder, ListAutomationRulePreviewSummariesResponse> {
    private static final SdkField<List<PreviewResultSummary>> PREVIEW_RESULT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("previewResultSummaries").getter(ListAutomationRulePreviewSummariesResponse.getter(ListAutomationRulePreviewSummariesResponse::previewResultSummaries)).setter(ListAutomationRulePreviewSummariesResponse.setter(Builder::previewResultSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewResultSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PreviewResultSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationRulePreviewSummariesResponse.getter(ListAutomationRulePreviewSummariesResponse::nextToken)).setter(ListAutomationRulePreviewSummariesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREVIEW_RESULT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationRulePreviewSummariesResponse.memberNameToFieldInitializer();
    private final List<PreviewResultSummary> previewResultSummaries;
    private final String nextToken;

    private ListAutomationRulePreviewSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.previewResultSummaries = builder.previewResultSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPreviewResultSummaries() {
        return this.previewResultSummaries != null && !(this.previewResultSummaries instanceof SdkAutoConstructList);
    }

    public final List<PreviewResultSummary> previewResultSummaries() {
        return this.previewResultSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreviewResultSummaries() ? this.previewResultSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulePreviewSummariesResponse)) {
            return false;
        }
        ListAutomationRulePreviewSummariesResponse other = (ListAutomationRulePreviewSummariesResponse)((Object)obj);
        return this.hasPreviewResultSummaries() == other.hasPreviewResultSummaries() && Objects.equals(this.previewResultSummaries(), other.previewResultSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationRulePreviewSummariesResponse").add("PreviewResultSummaries", this.hasPreviewResultSummaries() ? this.previewResultSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "previewResultSummaries": {
                return Optional.ofNullable(clazz.cast(this.previewResultSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("previewResultSummaries", PREVIEW_RESULT_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulePreviewSummariesResponse, T> g) {
        return obj -> g.apply((ListAutomationRulePreviewSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationResponse.BuilderImpl
    implements Builder {
        private List<PreviewResultSummary> previewResultSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulePreviewSummariesResponse model) {
            super(model);
            this.previewResultSummaries(model.previewResultSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PreviewResultSummary.Builder> getPreviewResultSummaries() {
            List<PreviewResultSummary.Builder> result = PreviewResultSummariesCopier.copyToBuilder(this.previewResultSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPreviewResultSummaries(Collection<PreviewResultSummary.BuilderImpl> previewResultSummaries) {
            this.previewResultSummaries = PreviewResultSummariesCopier.copyFromBuilder(previewResultSummaries);
        }

        @Override
        public final Builder previewResultSummaries(Collection<PreviewResultSummary> previewResultSummaries) {
            this.previewResultSummaries = PreviewResultSummariesCopier.copy(previewResultSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResultSummaries(PreviewResultSummary ... previewResultSummaries) {
            this.previewResultSummaries(Arrays.asList(previewResultSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResultSummaries(Consumer<PreviewResultSummary.Builder> ... previewResultSummaries) {
            this.previewResultSummaries(Stream.of(previewResultSummaries).map(c -> (PreviewResultSummary)((PreviewResultSummary.Builder)PreviewResultSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutomationRulePreviewSummariesResponse build() {
            return new ListAutomationRulePreviewSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationRulePreviewSummariesResponse> {
        public Builder previewResultSummaries(Collection<PreviewResultSummary> var1);

        public Builder previewResultSummaries(PreviewResultSummary ... var1);

        public Builder previewResultSummaries(Consumer<PreviewResultSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

