/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.ComputeOptimizerAutomationClient;
import software.amazon.awssdk.services.computeoptimizerautomation.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListRecommendedActionSummariesRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ListRecommendedActionSummariesResponse;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionSummary;

public class ListRecommendedActionSummariesIterable
implements SdkIterable<ListRecommendedActionSummariesResponse> {
    private final ComputeOptimizerAutomationClient client;
    private final ListRecommendedActionSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendedActionSummariesIterable(ComputeOptimizerAutomationClient client, ListRecommendedActionSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendedActionSummariesResponseFetcher();
    }

    public Iterator<ListRecommendedActionSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendedActionSummary> recommendedActionSummaries() {
        Function<ListRecommendedActionSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedActionSummaries() != null) {
                return response.recommendedActionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendedActionSummariesResponseFetcher
    implements SyncPageFetcher<ListRecommendedActionSummariesResponse> {
        private ListRecommendedActionSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedActionSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRecommendedActionSummariesResponse nextPage(ListRecommendedActionSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedActionSummariesIterable.this.client.listRecommendedActionSummaries(ListRecommendedActionSummariesIterable.this.firstRequest);
            }
            return ListRecommendedActionSummariesIterable.this.client.listRecommendedActionSummaries((ListRecommendedActionSummariesRequest)((Object)ListRecommendedActionSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

