/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizerautomation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizerautomation.model.ComputeOptimizerAutomationRequest;
import software.amazon.awssdk.services.computeoptimizerautomation.model.Criteria;
import software.amazon.awssdk.services.computeoptimizerautomation.model.OrganizationScope;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionType;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RecommendedActionTypeListCopier;
import software.amazon.awssdk.services.computeoptimizerautomation.model.RuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAutomationRulePreviewRequest
extends ComputeOptimizerAutomationRequest
implements ToCopyableBuilder<Builder, ListAutomationRulePreviewRequest> {
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleType").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::ruleTypeAsString)).setter(ListAutomationRulePreviewRequest.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()}).build();
    private static final SdkField<OrganizationScope> ORGANIZATION_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("organizationScope").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::organizationScope)).setter(ListAutomationRulePreviewRequest.setter(Builder::organizationScope)).constructor(OrganizationScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationScope").build()}).build();
    private static final SdkField<List<String>> RECOMMENDED_ACTION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedActionTypes").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::recommendedActionTypesAsStrings)).setter(ListAutomationRulePreviewRequest.setter(Builder::recommendedActionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedActionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("criteria").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::criteria)).setter(ListAutomationRulePreviewRequest.setter(Builder::criteria)).constructor(Criteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::maxResults)).setter(ListAutomationRulePreviewRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAutomationRulePreviewRequest.getter(ListAutomationRulePreviewRequest::nextToken)).setter(ListAutomationRulePreviewRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_TYPE_FIELD, ORGANIZATION_SCOPE_FIELD, RECOMMENDED_ACTION_TYPES_FIELD, CRITERIA_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAutomationRulePreviewRequest.memberNameToFieldInitializer();
    private final String ruleType;
    private final OrganizationScope organizationScope;
    private final List<String> recommendedActionTypes;
    private final Criteria criteria;
    private final Integer maxResults;
    private final String nextToken;

    private ListAutomationRulePreviewRequest(BuilderImpl builder) {
        super(builder);
        this.ruleType = builder.ruleType;
        this.organizationScope = builder.organizationScope;
        this.recommendedActionTypes = builder.recommendedActionTypes;
        this.criteria = builder.criteria;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final RuleType ruleType() {
        return RuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final OrganizationScope organizationScope() {
        return this.organizationScope;
    }

    public final List<RecommendedActionType> recommendedActionTypes() {
        return RecommendedActionTypeListCopier.copyStringToEnum(this.recommendedActionTypes);
    }

    public final boolean hasRecommendedActionTypes() {
        return this.recommendedActionTypes != null && !(this.recommendedActionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> recommendedActionTypesAsStrings() {
        return this.recommendedActionTypes;
    }

    public final Criteria criteria() {
        return this.criteria;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActionTypes() ? this.recommendedActionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutomationRulePreviewRequest)) {
            return false;
        }
        ListAutomationRulePreviewRequest other = (ListAutomationRulePreviewRequest)((Object)obj);
        return Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.organizationScope(), other.organizationScope()) && this.hasRecommendedActionTypes() == other.hasRecommendedActionTypes() && Objects.equals(this.recommendedActionTypesAsStrings(), other.recommendedActionTypesAsStrings()) && Objects.equals(this.criteria(), other.criteria()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAutomationRulePreviewRequest").add("RuleType", (Object)this.ruleTypeAsString()).add("OrganizationScope", (Object)this.organizationScope()).add("RecommendedActionTypes", this.hasRecommendedActionTypes() ? this.recommendedActionTypesAsStrings() : null).add("Criteria", (Object)this.criteria()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "organizationScope": {
                return Optional.ofNullable(clazz.cast(this.organizationScope()));
            }
            case "recommendedActionTypes": {
                return Optional.ofNullable(clazz.cast(this.recommendedActionTypesAsStrings()));
            }
            case "criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("organizationScope", ORGANIZATION_SCOPE_FIELD);
        map.put("recommendedActionTypes", RECOMMENDED_ACTION_TYPES_FIELD);
        map.put("criteria", CRITERIA_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutomationRulePreviewRequest, T> g) {
        return obj -> g.apply((ListAutomationRulePreviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ComputeOptimizerAutomationRequest.BuilderImpl
    implements Builder {
        private String ruleType;
        private OrganizationScope organizationScope;
        private List<String> recommendedActionTypes = DefaultSdkAutoConstructList.getInstance();
        private Criteria criteria;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutomationRulePreviewRequest model) {
            super(model);
            this.ruleType(model.ruleType);
            this.organizationScope(model.organizationScope);
            this.recommendedActionTypesWithStrings(model.recommendedActionTypes);
            this.criteria(model.criteria);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final OrganizationScope.Builder getOrganizationScope() {
            return this.organizationScope != null ? this.organizationScope.toBuilder() : null;
        }

        public final void setOrganizationScope(OrganizationScope.BuilderImpl organizationScope) {
            this.organizationScope = organizationScope != null ? organizationScope.build() : null;
        }

        @Override
        public final Builder organizationScope(OrganizationScope organizationScope) {
            this.organizationScope = organizationScope;
            return this;
        }

        public final Collection<String> getRecommendedActionTypes() {
            if (this.recommendedActionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendedActionTypes;
        }

        public final void setRecommendedActionTypes(Collection<String> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copy(recommendedActionTypes);
        }

        @Override
        public final Builder recommendedActionTypesWithStrings(Collection<String> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copy(recommendedActionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionTypesWithStrings(String ... recommendedActionTypes) {
            this.recommendedActionTypesWithStrings(Arrays.asList(recommendedActionTypes));
            return this;
        }

        @Override
        public final Builder recommendedActionTypes(Collection<RecommendedActionType> recommendedActionTypes) {
            this.recommendedActionTypes = RecommendedActionTypeListCopier.copyEnumToString(recommendedActionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActionTypes(RecommendedActionType ... recommendedActionTypes) {
            this.recommendedActionTypes(Arrays.asList(recommendedActionTypes));
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAutomationRulePreviewRequest build() {
            return new ListAutomationRulePreviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ComputeOptimizerAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAutomationRulePreviewRequest> {
        public Builder ruleType(String var1);

        public Builder ruleType(RuleType var1);

        public Builder organizationScope(OrganizationScope var1);

        default public Builder organizationScope(Consumer<OrganizationScope.Builder> organizationScope) {
            return this.organizationScope((OrganizationScope)((OrganizationScope.Builder)OrganizationScope.builder().applyMutation(organizationScope)).build());
        }

        public Builder recommendedActionTypesWithStrings(Collection<String> var1);

        public Builder recommendedActionTypesWithStrings(String ... var1);

        public Builder recommendedActionTypes(Collection<RecommendedActionType> var1);

        public Builder recommendedActionTypes(RecommendedActionType ... var1);

        public Builder criteria(Criteria var1);

        default public Builder criteria(Consumer<Criteria.Builder> criteria) {
            return this.criteria((Criteria)((Criteria.Builder)Criteria.builder().applyMutation(criteria)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

