/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.computeoptimizer.ComputeOptimizerClient;
import software.amazon.awssdk.services.computeoptimizer.internal.UserAgentUtils;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesRequest;
import software.amazon.awssdk.services.computeoptimizer.model.GetRecommendationPreferencesResponse;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationPreferencesDetail;

public class GetRecommendationPreferencesIterable
implements SdkIterable<GetRecommendationPreferencesResponse> {
    private final ComputeOptimizerClient client;
    private final GetRecommendationPreferencesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetRecommendationPreferencesIterable(ComputeOptimizerClient client, GetRecommendationPreferencesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetRecommendationPreferencesResponseFetcher();
    }

    public Iterator<GetRecommendationPreferencesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RecommendationPreferencesDetail> recommendationPreferencesDetails() {
        Function<GetRecommendationPreferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendationPreferencesDetails() != null) {
                return response.recommendationPreferencesDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetRecommendationPreferencesResponseFetcher
    implements SyncPageFetcher<GetRecommendationPreferencesResponse> {
        private GetRecommendationPreferencesResponseFetcher() {
        }

        public boolean hasNextPage(GetRecommendationPreferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetRecommendationPreferencesResponse nextPage(GetRecommendationPreferencesResponse previousPage) {
            if (previousPage == null) {
                return GetRecommendationPreferencesIterable.this.client.getRecommendationPreferences(GetRecommendationPreferencesIterable.this.firstRequest);
            }
            return GetRecommendationPreferencesIterable.this.client.getRecommendationPreferences((GetRecommendationPreferencesRequest)((Object)GetRecommendationPreferencesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

