/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSInstanceFindingReasonCode {
    CPU_OVERPROVISIONED("CPUOverprovisioned"),
    NETWORK_BANDWIDTH_OVERPROVISIONED("NetworkBandwidthOverprovisioned"),
    EBSIOPS_OVERPROVISIONED("EBSIOPSOverprovisioned"),
    EBSIOPS_UNDERPROVISIONED("EBSIOPSUnderprovisioned"),
    EBS_THROUGHPUT_OVERPROVISIONED("EBSThroughputOverprovisioned"),
    CPU_UNDERPROVISIONED("CPUUnderprovisioned"),
    NETWORK_BANDWIDTH_UNDERPROVISIONED("NetworkBandwidthUnderprovisioned"),
    EBS_THROUGHPUT_UNDERPROVISIONED("EBSThroughputUnderprovisioned"),
    NEW_GENERATION_DB_INSTANCE_CLASS_AVAILABLE("NewGenerationDBInstanceClassAvailable"),
    NEW_ENGINE_VERSION_AVAILABLE("NewEngineVersionAvailable"),
    DB_CLUSTER_WRITER_UNDERPROVISIONED("DBClusterWriterUnderprovisioned"),
    MEMORY_UNDERPROVISIONED("MemoryUnderprovisioned"),
    INSTANCE_STORAGE_READ_IOPS_UNDERPROVISIONED("InstanceStorageReadIOPSUnderprovisioned"),
    INSTANCE_STORAGE_WRITE_IOPS_UNDERPROVISIONED("InstanceStorageWriteIOPSUnderprovisioned"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSInstanceFindingReasonCode> VALUE_MAP;
    private final String value;

    private RDSInstanceFindingReasonCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSInstanceFindingReasonCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSInstanceFindingReasonCode> knownValues() {
        EnumSet<RDSInstanceFindingReasonCode> knownValues = EnumSet.allOf(RDSInstanceFindingReasonCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSInstanceFindingReasonCode.class, RDSInstanceFindingReasonCode::toString);
    }
}

