/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.PreferredResourceName;
import software.amazon.awssdk.services.computeoptimizer.model.PreferredResourceValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PreferredResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PreferredResource> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(PreferredResource.getter(PreferredResource::nameAsString)).setter(PreferredResource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> INCLUDE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includeList").getter(PreferredResource.getter(PreferredResource::includeList)).setter(PreferredResource.setter(Builder::includeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludeList").getter(PreferredResource.getter(PreferredResource::excludeList)).setter(PreferredResource.setter(Builder::excludeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INCLUDE_LIST_FIELD, EXCLUDE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PreferredResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> includeList;
    private final List<String> excludeList;

    private PreferredResource(BuilderImpl builder) {
        this.name = builder.name;
        this.includeList = builder.includeList;
        this.excludeList = builder.excludeList;
    }

    public final PreferredResourceName name() {
        return PreferredResourceName.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final boolean hasIncludeList() {
        return this.includeList != null && !(this.includeList instanceof SdkAutoConstructList);
    }

    public final List<String> includeList() {
        return this.includeList;
    }

    public final boolean hasExcludeList() {
        return this.excludeList != null && !(this.excludeList instanceof SdkAutoConstructList);
    }

    public final List<String> excludeList() {
        return this.excludeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeList() ? this.includeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeList() ? this.excludeList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PreferredResource)) {
            return false;
        }
        PreferredResource other = (PreferredResource)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && this.hasIncludeList() == other.hasIncludeList() && Objects.equals(this.includeList(), other.includeList()) && this.hasExcludeList() == other.hasExcludeList() && Objects.equals(this.excludeList(), other.excludeList());
    }

    public final String toString() {
        return ToString.builder((String)"PreferredResource").add("Name", (Object)this.nameAsString()).add("IncludeList", this.hasIncludeList() ? this.includeList() : null).add("ExcludeList", this.hasExcludeList() ? this.excludeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "includeList": {
                return Optional.ofNullable(clazz.cast(this.includeList()));
            }
            case "excludeList": {
                return Optional.ofNullable(clazz.cast(this.excludeList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("includeList", INCLUDE_LIST_FIELD);
        map.put("excludeList", EXCLUDE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PreferredResource, T> g) {
        return obj -> g.apply((PreferredResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> includeList = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PreferredResource model) {
            this.name(model.name);
            this.includeList(model.includeList);
            this.excludeList(model.excludeList);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(PreferredResourceName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Collection<String> getIncludeList() {
            if (this.includeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeList;
        }

        public final void setIncludeList(Collection<String> includeList) {
            this.includeList = PreferredResourceValuesCopier.copy(includeList);
        }

        @Override
        public final Builder includeList(Collection<String> includeList) {
            this.includeList = PreferredResourceValuesCopier.copy(includeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeList(String ... includeList) {
            this.includeList(Arrays.asList(includeList));
            return this;
        }

        public final Collection<String> getExcludeList() {
            if (this.excludeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeList;
        }

        public final void setExcludeList(Collection<String> excludeList) {
            this.excludeList = PreferredResourceValuesCopier.copy(excludeList);
        }

        @Override
        public final Builder excludeList(Collection<String> excludeList) {
            this.excludeList = PreferredResourceValuesCopier.copy(excludeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeList(String ... excludeList) {
            this.excludeList(Arrays.asList(excludeList));
            return this;
        }

        public PreferredResource build() {
            return new PreferredResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PreferredResource> {
        public Builder name(String var1);

        public Builder name(PreferredResourceName var1);

        public Builder includeList(Collection<String> var1);

        public Builder includeList(String ... var1);

        public Builder excludeList(Collection<String> var1);

        public Builder excludeList(String ... var1);
    }
}

