/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ECSServiceLaunchType {
    EC2("EC2"),
    FARGATE("Fargate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ECSServiceLaunchType> VALUE_MAP;
    private final String value;

    private ECSServiceLaunchType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ECSServiceLaunchType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ECSServiceLaunchType> knownValues() {
        EnumSet<ECSServiceLaunchType> knownValues = EnumSet.allOf(ECSServiceLaunchType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ECSServiceLaunchType.class, ECSServiceLaunchType::toString);
    }
}

