/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.AllocationStrategy;
import software.amazon.awssdk.services.computeoptimizer.model.AsgType;
import software.amazon.awssdk.services.computeoptimizer.model.MixedInstanceTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingGroupConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingGroupConfiguration> {
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("desiredCapacity").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::desiredCapacity)).setter(AutoScalingGroupConfiguration.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCapacity").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minSize").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::minSize)).setter(AutoScalingGroupConfiguration.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxSize").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::maxSize)).setter(AutoScalingGroupConfiguration.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxSize").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceType").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::instanceType)).setter(AutoScalingGroupConfiguration.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<String> ALLOCATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("allocationStrategy").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::allocationStrategyAsString)).setter(AutoScalingGroupConfiguration.setter(Builder::allocationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocationStrategy").build()}).build();
    private static final SdkField<Double> ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedInstanceHourReductionPercentage").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::estimatedInstanceHourReductionPercentage)).setter(AutoScalingGroupConfiguration.setter(Builder::estimatedInstanceHourReductionPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedInstanceHourReductionPercentage").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::typeAsString)).setter(AutoScalingGroupConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> MIXED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mixedInstanceTypes").getter(AutoScalingGroupConfiguration.getter(AutoScalingGroupConfiguration::mixedInstanceTypes)).setter(AutoScalingGroupConfiguration.setter(Builder::mixedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mixedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_CAPACITY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, INSTANCE_TYPE_FIELD, ALLOCATION_STRATEGY_FIELD, ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD, TYPE_FIELD, MIXED_INSTANCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingGroupConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer desiredCapacity;
    private final Integer minSize;
    private final Integer maxSize;
    private final String instanceType;
    private final String allocationStrategy;
    private final Double estimatedInstanceHourReductionPercentage;
    private final String type;
    private final List<String> mixedInstanceTypes;

    private AutoScalingGroupConfiguration(BuilderImpl builder) {
        this.desiredCapacity = builder.desiredCapacity;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.instanceType = builder.instanceType;
        this.allocationStrategy = builder.allocationStrategy;
        this.estimatedInstanceHourReductionPercentage = builder.estimatedInstanceHourReductionPercentage;
        this.type = builder.type;
        this.mixedInstanceTypes = builder.mixedInstanceTypes;
    }

    public final Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final AllocationStrategy allocationStrategy() {
        return AllocationStrategy.fromValue(this.allocationStrategy);
    }

    public final String allocationStrategyAsString() {
        return this.allocationStrategy;
    }

    public final Double estimatedInstanceHourReductionPercentage() {
        return this.estimatedInstanceHourReductionPercentage;
    }

    public final AsgType type() {
        return AsgType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasMixedInstanceTypes() {
        return this.mixedInstanceTypes != null && !(this.mixedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> mixedInstanceTypes() {
        return this.mixedInstanceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedInstanceHourReductionPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMixedInstanceTypes() ? this.mixedInstanceTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupConfiguration)) {
            return false;
        }
        AutoScalingGroupConfiguration other = (AutoScalingGroupConfiguration)obj;
        return Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.allocationStrategyAsString(), other.allocationStrategyAsString()) && Objects.equals(this.estimatedInstanceHourReductionPercentage(), other.estimatedInstanceHourReductionPercentage()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasMixedInstanceTypes() == other.hasMixedInstanceTypes() && Objects.equals(this.mixedInstanceTypes(), other.mixedInstanceTypes());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingGroupConfiguration").add("DesiredCapacity", (Object)this.desiredCapacity()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("InstanceType", (Object)this.instanceType()).add("AllocationStrategy", (Object)this.allocationStrategyAsString()).add("EstimatedInstanceHourReductionPercentage", (Object)this.estimatedInstanceHourReductionPercentage()).add("Type", (Object)this.typeAsString()).add("MixedInstanceTypes", this.hasMixedInstanceTypes() ? this.mixedInstanceTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "desiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "minSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "maxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "allocationStrategy": {
                return Optional.ofNullable(clazz.cast(this.allocationStrategyAsString()));
            }
            case "estimatedInstanceHourReductionPercentage": {
                return Optional.ofNullable(clazz.cast(this.estimatedInstanceHourReductionPercentage()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "mixedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.mixedInstanceTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("desiredCapacity", DESIRED_CAPACITY_FIELD);
        map.put("minSize", MIN_SIZE_FIELD);
        map.put("maxSize", MAX_SIZE_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("allocationStrategy", ALLOCATION_STRATEGY_FIELD);
        map.put("estimatedInstanceHourReductionPercentage", ESTIMATED_INSTANCE_HOUR_REDUCTION_PERCENTAGE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("mixedInstanceTypes", MIXED_INSTANCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupConfiguration, T> g) {
        return obj -> g.apply((AutoScalingGroupConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer desiredCapacity;
        private Integer minSize;
        private Integer maxSize;
        private String instanceType;
        private String allocationStrategy;
        private Double estimatedInstanceHourReductionPercentage;
        private String type;
        private List<String> mixedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupConfiguration model) {
            this.desiredCapacity(model.desiredCapacity);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.instanceType(model.instanceType);
            this.allocationStrategy(model.allocationStrategy);
            this.estimatedInstanceHourReductionPercentage(model.estimatedInstanceHourReductionPercentage);
            this.type(model.type);
            this.mixedInstanceTypes(model.mixedInstanceTypes);
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAllocationStrategy() {
            return this.allocationStrategy;
        }

        public final void setAllocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
        }

        @Override
        public final Builder allocationStrategy(String allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        @Override
        public final Builder allocationStrategy(AllocationStrategy allocationStrategy) {
            this.allocationStrategy(allocationStrategy == null ? null : allocationStrategy.toString());
            return this;
        }

        public final Double getEstimatedInstanceHourReductionPercentage() {
            return this.estimatedInstanceHourReductionPercentage;
        }

        public final void setEstimatedInstanceHourReductionPercentage(Double estimatedInstanceHourReductionPercentage) {
            this.estimatedInstanceHourReductionPercentage = estimatedInstanceHourReductionPercentage;
        }

        @Override
        public final Builder estimatedInstanceHourReductionPercentage(Double estimatedInstanceHourReductionPercentage) {
            this.estimatedInstanceHourReductionPercentage = estimatedInstanceHourReductionPercentage;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AsgType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getMixedInstanceTypes() {
            if (this.mixedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mixedInstanceTypes;
        }

        public final void setMixedInstanceTypes(Collection<String> mixedInstanceTypes) {
            this.mixedInstanceTypes = MixedInstanceTypesCopier.copy(mixedInstanceTypes);
        }

        @Override
        public final Builder mixedInstanceTypes(Collection<String> mixedInstanceTypes) {
            this.mixedInstanceTypes = MixedInstanceTypesCopier.copy(mixedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mixedInstanceTypes(String ... mixedInstanceTypes) {
            this.mixedInstanceTypes(Arrays.asList(mixedInstanceTypes));
            return this;
        }

        public AutoScalingGroupConfiguration build() {
            return new AutoScalingGroupConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingGroupConfiguration> {
        public Builder desiredCapacity(Integer var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder instanceType(String var1);

        public Builder allocationStrategy(String var1);

        public Builder allocationStrategy(AllocationStrategy var1);

        public Builder estimatedInstanceHourReductionPercentage(Double var1);

        public Builder type(String var1);

        public Builder type(AsgType var1);

        public Builder mixedInstanceTypes(Collection<String> var1);

        public Builder mixedInstanceTypes(String ... var1);
    }
}

