/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ICD10CMConceptListCopier {
    static List<ICD10CMConcept> copy(Collection<? extends ICD10CMConcept> icd10CMConceptListParam) {
        List<ICD10CMConcept> list;
        if (icd10CMConceptListParam == null || icd10CMConceptListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMConcept> modifiableList = new ArrayList<>();
            icd10CMConceptListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ICD10CMConcept> copyFromBuilder(Collection<? extends ICD10CMConcept.Builder> icd10CMConceptListParam) {
        List<ICD10CMConcept> list;
        if (icd10CMConceptListParam == null || icd10CMConceptListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMConcept> modifiableList = new ArrayList<>();
            icd10CMConceptListParam.forEach(entry -> {
                ICD10CMConcept member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ICD10CMConcept.Builder> copyToBuilder(Collection<? extends ICD10CMConcept> icd10CMConceptListParam) {
        List<ICD10CMConcept.Builder> list;
        if (icd10CMConceptListParam == null || icd10CMConceptListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ICD10CMConcept.Builder> modifiableList = new ArrayList<>();
            icd10CMConceptListParam.forEach(entry -> {
                ICD10CMConcept.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
