/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ToxicContentType {
    GRAPHIC("GRAPHIC"),
    HARASSMENT_OR_ABUSE("HARASSMENT_OR_ABUSE"),
    HATE_SPEECH("HATE_SPEECH"),
    INSULT("INSULT"),
    PROFANITY("PROFANITY"),
    SEXUAL("SEXUAL"),
    VIOLENCE_OR_THREAT("VIOLENCE_OR_THREAT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ToxicContentType> VALUE_MAP;
    private final String value;

    private ToxicContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ToxicContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ToxicContentType> knownValues() {
        EnumSet<ToxicContentType> knownValues = EnumSet.allOf(ToxicContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ToxicContentType.class, ToxicContentType::toString);
    }
}

