/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Split {
    TRAIN("TRAIN"),
    TEST("TEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Split> VALUE_MAP;
    private final String value;

    private Split(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Split fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Split> knownValues() {
        EnumSet<Split> knownValues = EnumSet.allOf(Split.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Split.class, Split::toString);
    }
}

