/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.InputDataConfig;
import software.amazon.awssdk.services.comprehend.model.JobStatus;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.services.comprehend.model.OutputDataConfig;
import software.amazon.awssdk.services.comprehend.model.TargetEventTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventsDetectionJobProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventsDetectionJobProperties> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::jobId)).setter(EventsDetectionJobProperties.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobArn").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::jobArn)).setter(EventsDetectionJobProperties.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::jobName)).setter(EventsDetectionJobProperties.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::jobStatusAsString)).setter(EventsDetectionJobProperties.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::message)).setter(EventsDetectionJobProperties.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> SUBMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmitTime").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::submitTime)).setter(EventsDetectionJobProperties.setter(Builder::submitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmitTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::endTime)).setter(EventsDetectionJobProperties.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputDataConfig").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::inputDataConfig)).setter(EventsDetectionJobProperties.setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::outputDataConfig)).setter(EventsDetectionJobProperties.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::languageCodeAsString)).setter(EventsDetectionJobProperties.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataAccessRoleArn").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::dataAccessRoleArn)).setter(EventsDetectionJobProperties.setter(Builder::dataAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()}).build();
    private static final SdkField<List<String>> TARGET_EVENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetEventTypes").getter(EventsDetectionJobProperties.getter(EventsDetectionJobProperties::targetEventTypes)).setter(EventsDetectionJobProperties.setter(Builder::targetEventTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEventTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, JOB_ARN_FIELD, JOB_NAME_FIELD, JOB_STATUS_FIELD, MESSAGE_FIELD, SUBMIT_TIME_FIELD, END_TIME_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, LANGUAGE_CODE_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, TARGET_EVENT_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventsDetectionJobProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final String jobArn;
    private final String jobName;
    private final String jobStatus;
    private final String message;
    private final Instant submitTime;
    private final Instant endTime;
    private final InputDataConfig inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final String languageCode;
    private final String dataAccessRoleArn;
    private final List<String> targetEventTypes;

    private EventsDetectionJobProperties(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.message = builder.message;
        this.submitTime = builder.submitTime;
        this.endTime = builder.endTime;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.languageCode = builder.languageCode;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.targetEventTypes = builder.targetEventTypes;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final String message() {
        return this.message;
    }

    public final Instant submitTime() {
        return this.submitTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final InputDataConfig inputDataConfig() {
        return this.inputDataConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public final boolean hasTargetEventTypes() {
        return this.targetEventTypes != null && !(this.targetEventTypes instanceof SdkAutoConstructList);
    }

    public final List<String> targetEventTypes() {
        return this.targetEventTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.submitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetEventTypes() ? this.targetEventTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventsDetectionJobProperties)) {
            return false;
        }
        EventsDetectionJobProperties other = (EventsDetectionJobProperties)obj;
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.submitTime(), other.submitTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.dataAccessRoleArn(), other.dataAccessRoleArn()) && this.hasTargetEventTypes() == other.hasTargetEventTypes() && Objects.equals(this.targetEventTypes(), other.targetEventTypes());
    }

    public final String toString() {
        return ToString.builder((String)"EventsDetectionJobProperties").add("JobId", (Object)this.jobId()).add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("JobStatus", (Object)this.jobStatusAsString()).add("Message", (Object)this.message()).add("SubmitTime", (Object)this.submitTime()).add("EndTime", (Object)this.endTime()).add("InputDataConfig", (Object)this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("LanguageCode", (Object)this.languageCodeAsString()).add("DataAccessRoleArn", (Object)this.dataAccessRoleArn()).add("TargetEventTypes", this.hasTargetEventTypes() ? this.targetEventTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "JobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "SubmitTime": {
                return Optional.ofNullable(clazz.cast(this.submitTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "DataAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRoleArn()));
            }
            case "TargetEventTypes": {
                return Optional.ofNullable(clazz.cast(this.targetEventTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("JobArn", JOB_ARN_FIELD);
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobStatus", JOB_STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("SubmitTime", SUBMIT_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("OutputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("TargetEventTypes", TARGET_EVENT_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventsDetectionJobProperties, T> g) {
        return obj -> g.apply((EventsDetectionJobProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobId;
        private String jobArn;
        private String jobName;
        private String jobStatus;
        private String message;
        private Instant submitTime;
        private Instant endTime;
        private InputDataConfig inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String languageCode;
        private String dataAccessRoleArn;
        private List<String> targetEventTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventsDetectionJobProperties model) {
            this.jobId(model.jobId);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.jobStatus(model.jobStatus);
            this.message(model.message);
            this.submitTime(model.submitTime);
            this.endTime(model.endTime);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.languageCode(model.languageCode);
            this.dataAccessRoleArn(model.dataAccessRoleArn);
            this.targetEventTypes(model.targetEventTypes);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getSubmitTime() {
            return this.submitTime;
        }

        public final void setSubmitTime(Instant submitTime) {
            this.submitTime = submitTime;
        }

        @Override
        public final Builder submitTime(Instant submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return this.inputDataConfig != null ? this.inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final Collection<String> getTargetEventTypes() {
            if (this.targetEventTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetEventTypes;
        }

        public final void setTargetEventTypes(Collection<String> targetEventTypes) {
            this.targetEventTypes = TargetEventTypesCopier.copy(targetEventTypes);
        }

        @Override
        public final Builder targetEventTypes(Collection<String> targetEventTypes) {
            this.targetEventTypes = TargetEventTypesCopier.copy(targetEventTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetEventTypes(String ... targetEventTypes) {
            this.targetEventTypes(Arrays.asList(targetEventTypes));
            return this;
        }

        public EventsDetectionJobProperties build() {
            return new EventsDetectionJobProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventsDetectionJobProperties> {
        public Builder jobId(String var1);

        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder message(String var1);

        public Builder submitTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder inputDataConfig(InputDataConfig var1);

        default public Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return this.inputDataConfig((InputDataConfig)((InputDataConfig.Builder)InputDataConfig.builder().applyMutation(inputDataConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder dataAccessRoleArn(String var1);

        public Builder targetEventTypes(Collection<String> var1);

        public Builder targetEventTypes(String ... var1);
    }
}

